/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.sentry;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Depot;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Event;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.Virtual;
import io.vertx.up.exception.WebException;
import io.vertx.up.rs.Sentry;
import io.vertx.up.rs.hunt.Answer;
import io.vertx.up.rs.hunt.BaseAim;
import io.vertx.up.rs.regular.Ruler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class StandardVerifier
extends BaseAim
implements Sentry {
    @Override
    public Handler<RoutingContext> signal(Depot depot) {
        Map<String, List<Rule>> rulers = this.verifier().buildRulers(depot);
        return context -> {
            Object[] args = this.buildArgs((RoutingContext)context, depot.getEvent());
            WebException error = this.verifyPureArguments(depot, args);
            if (null == error) {
                error = this.verifyBody(rulers, args);
                if (null == error) {
                    context.next();
                } else {
                    this.replyError((RoutingContext)context, error, depot.getEvent());
                }
            } else {
                this.replyError((RoutingContext)context, error, depot.getEvent());
            }
        };
    }

    private void replyError(RoutingContext context, WebException error, Event event) {
        Envelop envelop = Envelop.failure(error);
        Answer.reply(context, envelop, event);
    }

    private WebException verifyBody(Map<String, List<Rule>> rulers, Object[] args) {
        Object body;
        WebException error = null;
        if (!rulers.isEmpty() && null != (body = args[0])) {
            JsonObject data = (JsonObject)body;
            error = this.verifyBody(rulers, data);
        }
        return error;
    }

    private WebException verifyBody(Map<String, List<Rule>> rulers, JsonObject data) {
        WebException error = null;
        block0: for (String field : rulers.keySet()) {
            Object value = data.getValue(field);
            List<Rule> rules = rulers.get(field);
            for (Rule rule : rules) {
                Ruler ruler = Ruler.get(rule.getType());
                if (null != ruler) {
                    error = ruler.verify(field, value, rule);
                }
                if (null == error) continue;
                break block0;
            }
        }
        return error;
    }

    private WebException verifyPureArguments(Depot depot, Object[] args) {
        Event event = depot.getEvent();
        Object proxy = event.getProxy();
        Method method = event.getAction();
        WebException error = null;
        try {
            if (null != proxy && !Virtual.is(proxy)) {
                this.verifier().verifyMethod(proxy, method, args);
            }
        }
        catch (WebException ex) {
            error = ex;
        }
        return error;
    }
}

