/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.up.Launcher;
import io.vertx.up.Motor;
import io.vertx.up.log.Annal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class ZeroLauncher
implements Launcher {
    private static final Annal LOGGER = Annal.get(ZeroLauncher.class);
    private static final ConcurrentMap<String, Vertx> VERTX = new ConcurrentHashMap<String, Vertx>();

    @Override
    public void start(Consumer<Vertx> callback) {
        Motor.start(this.getClass(), callback, this::startStandalone, this::startCluster, LOGGER);
    }

    @Override
    public void stop(Consumer<Vertx> callback) {
    }

    private void startStandalone(Consumer<Vertx> consumer) {
        Motor.each((name, option) -> {
            Vertx vertx = Vertx.vertx((VertxOptions)option);
            Motor.codec(vertx.eventBus());
            VERTX.putIfAbsent((String)name, vertx);
            consumer.accept(vertx);
        });
    }

    private void startCluster(ClusterManager manager, Consumer<Vertx> consumer) {
        Motor.each((name, option) -> Vertx.clusteredVertx((VertxOptions)option, clustered -> {
            Vertx vertx = (Vertx)clustered.result();
            Motor.codec(vertx.eventBus());
            manager.setVertx(vertx);
            VERTX.putIfAbsent((String)name, vertx);
            consumer.accept(vertx);
        }));
    }
}

