/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroHttpAgent;
import io.vertx.up.rs.Extractor;
import io.vertx.up.rs.config.AgentExtractor;
import io.vertx.up.tool.Statute;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.ZeroHelper;
import io.vertx.up.web.anima.Scatter;
import io.vertx.up.web.anima.Verticles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AgentScatter
implements Scatter {
    private static final Annal LOGGER = Annal.get(AgentScatter.class);
    private static final Class<?>[] DEFAULT_AGENTS = new Class[]{ZeroHttpAgent.class};
    private static final ConcurrentMap<ServerType, Class<?>> INTERNALS = new ConcurrentHashMap<ServerType, Class<?>>(){
        {
            this.put(ServerType.HTTP, ZeroHttpAgent.class);
        }
    };

    @Override
    public void connect(Vertx vertx) {
        ConcurrentMap<ServerType, Class<?>> agents = this.getAgents();
        Extractor extractor = (Extractor)Instance.instance(AgentExtractor.class, (Object[])new Object[0]);
        Fn.itMap(agents, (type, clazz) -> {
            DeploymentOptions option = (DeploymentOptions)extractor.extract((Class<?>)clazz);
            Verticles.deploy(vertx, clazz, option, LOGGER);
        });
    }

    private ConcurrentMap<ServerType, List<Class<?>>> getMergedAgents() {
        ConcurrentMap<ServerType, List<Class<?>>> agents = ZeroAnno.getAgents();
        if (agents.isEmpty()) {
            agents.put(ServerType.HTTP, new ArrayList(INTERNALS.values()));
        }
        return agents;
    }

    private ConcurrentMap<ServerType, Class<?>> getAgents() {
        ConcurrentMap<ServerType, List<Class<?>>> agents = this.getMergedAgents();
        ConcurrentMap<ServerType, Boolean> defines = ZeroHelper.isAgentDefined(agents, DEFAULT_AGENTS);
        ConcurrentHashMap ret = new ConcurrentHashMap();
        Fn.itMap(agents, (type, list) -> Fn.getSemi((defines.containsKey(type) && (Boolean)defines.get(type) != false ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Class found = (Class)Statute.findUnique((List)list, item -> INTERNALS.get(type) != item);
            if (null != found) {
                LOGGER.info("[ ZERO ] User defined agent {0} of type = {1}, the default will be overwritten.", new Object[]{found.getName(), type});
                ret.put((ServerType)type, found);
            }
            return null;
        }, () -> {
            Class found = (Class)Statute.findUnique((List)list, item -> INTERNALS.get(type) == item);
            if (null != found) {
                ret.put((ServerType)type, found);
            }
            return null;
        }));
        return ret;
    }
}

