/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.vertx.core.Vertx;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.eon.Plugins;
import io.vertx.up.exception.PluginSpecificationException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Statute;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.up.web.anima.Scatter;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroLime;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class InfixScatter
implements Scatter {
    private static final Annal LOGGER = Annal.get(InfixScatter.class);
    private static final Node<ConcurrentMap<String, String>> node = (Node)Instance.singleton(ZeroLime.class, (Object[])new Object[0]);

    @Override
    public void connect(Vertx vertx) {
        ConcurrentMap enabled = Statute.reduce(((ConcurrentMap)node.read()).keySet(), (ConcurrentMap)ZeroAmbient.getInjections());
        ConcurrentMap injections = Statute.reduce((ConcurrentMap)Plugins.INFIX_MAP, (ConcurrentMap)enabled);
        injections.values().stream().forEach(item -> {
            if (null != item && item.isAnnotationPresent(Plugin.class)) {
                Method method = this.findInit((Class<?>)item);
                Fn.flingUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, PluginSpecificationException.class, (Object[])new Object[]{this.getClass(), item.getName()});
                Fn.safeJvm(() -> method.invoke(null, vertx), (Annal)LOGGER);
            }
        });
    }

    private Method findInit(Class<?> clazz) {
        return (Method)Fn.get(() -> {
            Method[] methods = clazz.getDeclaredMethods();
            List found = Arrays.stream(methods).filter(item -> "init".equals(item.getName()) && this.validMethod((Method)item)).collect(Collectors.toList());
            return 1 == found.size() ? (Method)found.get(0) : null;
        }, (Object[])new Object[]{clazz});
    }

    private boolean validMethod(Method method) {
        return (Void.TYPE == method.getReturnType() || Void.class == method.getReturnType()) && Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }
}

