/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.origin;

import io.vertx.up.eon.Plugins;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.up.web.thread.AffluxThread;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class AffluxInquirer
implements Inquirer<ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>>> {
    private static final Annal LOGGER = Annal.get(AffluxInquirer.class);

    @Override
    public ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>> scan(Set<Class<?>> classes) {
        Set enabled = classes.stream().filter(item -> Anno.isMark((Class)item, (Set)Plugins.INJECT_ANNOTATIONS)).collect(Collectors.toSet());
        ArrayList<AffluxThread> threadReference = new ArrayList<AffluxThread>();
        for (Class clazz : enabled) {
            AffluxThread thread2 = new AffluxThread(clazz, classes);
            threadReference.add(thread2);
            thread2.start();
        }
        threadReference.forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                LOGGER.jvm((Throwable)ex);
            }
        });
        ConcurrentHashMap affluxes = new ConcurrentHashMap();
        for (AffluxThread thread2 : threadReference) {
            if (thread2.isEmpty()) continue;
            Class<?> key = thread2.getClassKey();
            ConcurrentMap<String, Class<?>> fields = thread2.getFieldMap();
            affluxes.put(key, fields);
            LOGGER.info("[ ZERO ] ( {1} Inject ) The Zero system has found \"{0}\" object contains {1} components of @Inject or ( javax.inject.infix.* ).", new Object[]{key.getName(), fields.size()});
        }
        return affluxes;
    }
}

