/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.thread;

import io.vertx.up.annotations.Qualifier;
import io.vertx.up.eon.Plugins;
import io.vertx.up.exception.MultiAnnotatedException;
import io.vertx.up.exception.NamedImplementionException;
import io.vertx.up.exception.NamedNotFoundException;
import io.vertx.up.exception.QualifierMissedException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.up.tool.mirror.Instance;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

public class AffluxThread
extends Thread {
    private static final Annal LOGGER = Annal.get(AffluxThread.class);
    private final ConcurrentMap<String, Class<?>> fieldMap = new ConcurrentHashMap();
    private final transient Class<?> reference;
    private final transient Set<Class<?>> namedSet;
    private final transient Set<Class<?>> classes;

    public AffluxThread(Class<?> clazz, Set<Class<?>> classes) {
        this.setName("zero-injection-scanner-" + this.getId());
        this.reference = clazz;
        this.classes = classes;
        this.namedSet = classes.stream().filter(item -> item.isAnnotationPresent(Named.class)).collect(Collectors.toSet());
    }

    @Override
    public void run() {
        if (null != this.reference) {
            List fields = Arrays.stream(this.reference.getDeclaredFields()).filter(field -> Anno.isMark((Field)field, (Set)Plugins.INJECT_ANNOTATIONS)).collect(Collectors.toList());
            for (Field field2 : fields) {
                if (field2.isAnnotationPresent(Inject.class)) {
                    this.scanStandard(field2);
                    continue;
                }
                this.scanSpecific(field2);
            }
        }
    }

    private void scanStandard(Field field) {
        Class<?> type = field.getType();
        if (type.isInterface()) {
            List<Class<?>> target = this.classes.stream().filter(item -> Instance.isMatch((Class)item, (Class)type)).collect(Collectors.toList());
            if (1 == target.size()) {
                Class targetCls = (Class)target.get(0);
                LOGGER.info("[ ZERO ] ( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), targetCls.getName(), Inject.class});
                this.fieldMap.put(field.getName(), targetCls);
            } else {
                this.scanQualifier(field, target);
            }
        } else {
            this.fieldMap.put(field.getName(), type);
            LOGGER.info("[ ZERO ] ( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), type.getName(), Inject.class});
        }
    }

    private void scanQualifier(Field field, List<Class<?>> instanceCls) {
        Qualifier annotation = field.getAnnotation(Qualifier.class);
        Fn.flingUp((null == annotation ? 1 : 0) != 0, (Annal)LOGGER, QualifierMissedException.class, (Object[])new Object[]{this.getClass(), field.getName(), field.getDeclaringClass().getName()});
        boolean match = instanceCls.stream().allMatch(item -> item.isAnnotationPresent(Named.class));
        Set names = instanceCls.stream().map(Class::getName).collect(Collectors.toSet());
        Fn.flingUp((!match ? 1 : 0) != 0, (Annal)LOGGER, NamedImplementionException.class, (Object[])new Object[]{this.getClass(), names, field.getType().getName()});
        String value = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        Optional<Class> verified = instanceCls.stream().filter(item -> {
            Named target = item.getAnnotation(Named.class);
            String targetValue = (String)Instance.invoke((Object)target, (String)"value", (Object[])new Object[0]);
            return value.equals(targetValue) && !StringUtil.isNil((String)targetValue);
        }).findAny();
        Fn.flingUp((!verified.isPresent() ? 1 : 0) != 0, (Annal)LOGGER, NamedNotFoundException.class, (Object[])new Object[]{this.getClass(), names, value});
        this.fieldMap.put(field.getName(), verified.get());
    }

    private void scanSpecific(Field field) {
        Set defineds = Plugins.INFIX_MAP.keySet();
        Annotation[] annotations = field.getDeclaredAnnotations();
        HashSet<String> set = new HashSet<String>();
        Annotation hitted = null;
        for (Annotation annotation : annotations) {
            if (!defineds.contains(annotation.annotationType())) continue;
            hitted = annotation;
            set.add(annotation.annotationType().getName());
        }
        Fn.flingUp((1 < set.size() ? 1 : 0) != 0, (Annal)LOGGER, MultiAnnotatedException.class, (Object[])new Object[]{this.getClass(), field.getName(), field.getDeclaringClass().getName(), set});
        LOGGER.info("[ ZERO ] ( Field ) Class \"{0}\" scanned field = \"{1}\" of {2} annotated with {3}. will be initialized with DI container.", new Object[]{this.reference, field.getName(), field.getDeclaringClass().getName(), hitted.annotationType().getName()});
        this.fieldMap.put(field.getName(), field.getType());
    }

    public ConcurrentMap<String, Class<?>> getFieldMap() {
        return this.fieldMap;
    }

    public Class<?> getClassKey() {
        return this.reference;
    }

    public boolean isEmpty() {
        return this.fieldMap.isEmpty();
    }
}

