/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ssl;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.up.eon.em.CertType;
import io.vertx.up.micro.ssl.server.JksCert;
import io.vertx.up.micro.ssl.server.PemCert;
import io.vertx.up.micro.ssl.server.PfxCert;
import io.vertx.up.tool.mirror.Instance;

public interface CertPipe<I> {
    public Handler<TCPSSLOptions> parse(I var1);

    public static CertPipe<JsonObject> get(CertType type) {
        CertPipe pipe = null;
        switch (type) {
            case PKCS12: {
                pipe = (CertPipe)Instance.singleton(PfxCert.class, (Object[])new Object[0]);
                break;
            }
            case JKS: {
                pipe = (CertPipe)Instance.singleton(JksCert.class, (Object[])new Object[0]);
                break;
            }
            case PEM: {
                pipe = (CertPipe)Instance.singleton(PemCert.class, (Object[])new Object[0]);
            }
        }
        return pipe;
    }
}

