/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.vertx.ext.web.RoutingContext;
import io.vertx.up.annotations.Codex;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.hold.Virtual;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.announce.Rigor;
import io.vertx.up.rs.hunt.Answer;
import io.vertx.up.rs.validation.Validator;
import io.vertx.up.tool.container.KeyPair;
import io.vertx.up.tool.mirror.Anno;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

class Flower {
    private static final Annal LOGGER = Annal.get(Flower.class);

    Flower() {
    }

    static <T> Envelop continuous(RoutingContext context, T entity) {
        Envelop envelop = Envelop.success(entity);
        envelop.setHeaders(context.request().headers());
        envelop.setUser(context.user());
        envelop.setSession(context.session());
        return envelop;
    }

    static void executeRequest(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot, Object[] args, Validator verifier) {
        WebException error = Flower.verifyPureArguments(verifier, depot, args);
        if (null == error) {
            KeyPair found = Anno.findParameter((Method)depot.getEvent().getAction(), Codex.class);
            if (null == found.getValue()) {
                context.next();
            } else {
                Class type = (Class)found.getValue();
                Object value = args[(Integer)found.getKey()];
                Flower.verifyCodex(context, rulers, depot, type, value);
            }
        } else {
            Flower.replyError(context, error, depot.getEvent());
        }
    }

    private static void verifyCodex(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot, Class<?> type, Object value) {
        Rigor rigor = Rigor.get(type);
        if (null == rigor) {
            LOGGER.warn("[ ZERO ] Zero system could not find Rigor for type = {0}.", new Object[]{type});
            context.next();
        } else {
            WebException error = rigor.verify(rulers, value);
            if (null == error) {
                context.next();
            } else {
                Flower.replyError(context, error, depot.getEvent());
            }
        }
    }

    static void replyError(RoutingContext context, WebException error, Event event) {
        Envelop envelop = Envelop.failure(error);
        Answer.reply(context, envelop, event);
    }

    private static WebException verifyPureArguments(Validator verifier, Depot depot, Object[] args) {
        Event event = depot.getEvent();
        Object proxy = event.getProxy();
        Method method = event.getAction();
        WebException error = null;
        try {
            if (!Virtual.is(proxy)) {
                verifier.verifyMethod(proxy, method, args);
            }
        }
        catch (WebException ex) {
            error = ex;
        }
        return error;
    }
}

