/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Filler;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.zero.exception.AnnotationRepeatException;
import io.vertx.zero.exception.EventActionNoneException;
import io.vertx.zero.exception.ParamAnnotationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.BodyParam;
import javax.ws.rs.StreamParam;

public class Verifier {
    private static final Annal LOGGER = Annal.get(Verifier.class);

    public static void verify(Event event) {
        Method method = event.getAction();
        Fn.flingUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, EventActionNoneException.class, (Object[])new Object[]{Verifier.class, event});
        Verifier.verify(method, BodyParam.class);
        Verifier.verify(method, StreamParam.class);
        for (Parameter parameter : method.getParameters()) {
            Verifier.verify(parameter);
        }
    }

    public static void verify(Method method, Class<? extends Annotation> annoCls) {
        Annotation[][] annotations = method.getParameterAnnotations();
        int occurs = Anno.occurs((Annotation[][])annotations, annoCls);
        Fn.flingUp((1 < occurs ? 1 : 0) != 0, (Annal)LOGGER, AnnotationRepeatException.class, (Object[])new Object[]{Verifier.class, method.getName(), annoCls, occurs});
    }

    public static void verify(Parameter parameter) {
        Annotation[] annotations = parameter.getDeclaredAnnotations();
        List annotationList = Arrays.stream(annotations).filter(item -> Filler.PARAMS.containsKey(item.annotationType())).collect(Collectors.toList());
        int multi = annotationList.size();
        Fn.flingUp((1 < multi ? 1 : 0) != 0, (Annal)LOGGER, ParamAnnotationException.class, (Object[])new Object[]{Verifier.class, parameter.getName(), multi});
    }
}

