/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.validation;

import io.vertx.up.log.Annal;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetResources;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class ValidatorBundleLocator
implements ResourceBundleLocator {
    private static final Annal LOGGER = Annal.get(ValidatorBundleLocator.class);
    private static final boolean RESOURCE_BUNDLE_CONTROL_INSTANTIABLE = ValidatorBundleLocator.determineAvailabilityOfResourceBundleControl();
    private final String bundleName;
    private final ClassLoader classLoader;
    private final boolean aggregate;

    public ValidatorBundleLocator(String bundleName) {
        this(bundleName, null);
    }

    public ValidatorBundleLocator(String bundleName, ClassLoader classLoader) {
        this(bundleName, classLoader, false);
    }

    public ValidatorBundleLocator(String bundleName, ClassLoader classLoader, boolean aggregate) {
        Contracts.assertNotNull((Object)bundleName, (String)"bundleName");
        this.bundleName = bundleName;
        this.classLoader = classLoader;
        this.aggregate = aggregate && RESOURCE_BUNDLE_CONTROL_INSTANTIABLE;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader classLoader;
        ResourceBundle rb = null;
        if (this.classLoader != null) {
            rb = this.loadBundle(this.classLoader, locale, this.bundleName + " not found by user-provided classloader");
        }
        if (rb == null && (classLoader = (ClassLoader)ValidatorBundleLocator.run(GetClassLoader.fromContext())) != null) {
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by thread context classloader");
        }
        if (rb == null) {
            classLoader = (ClassLoader)ValidatorBundleLocator.run(GetClassLoader.fromClass(ValidatorBundleLocator.class));
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by validator classloader");
        }
        if (rb != null) {
            LOGGER.debug("[ ZERO ] {0} found.", new Object[]{this.bundleName});
        } else {
            LOGGER.debug("[ ZERO ] {0} not found.", new Object[]{this.bundleName});
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = this.aggregate ? ResourceBundle.getBundle(this.bundleName, locale, classLoader, AggregateResourceBundle.CONTROL) : ResourceBundle.getBundle(this.bundleName, locale, classLoader);
        }
        catch (MissingResourceException var6) {
            LOGGER.debug(var6.getMessage(), new Object[0]);
        }
        return rb;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static boolean determineAvailabilityOfResourceBundleControl() {
        try {
            ResourceBundle.Control dummyControl = AggregateResourceBundle.CONTROL;
            if (dummyControl == null) {
                return false;
            }
            Method getModule = (Method)ValidatorBundleLocator.run(GetMethod.action(Class.class, (String)"getModule"));
            if (getModule == null) {
                return true;
            }
            Object module = getModule.invoke(ValidatorBundleLocator.class, new Object[0]);
            Method isNamedMethod = (Method)ValidatorBundleLocator.run(GetMethod.action(module.getClass(), (String)"isNamed"));
            boolean isNamed = (Boolean)isNamedMethod.invoke(module, new Object[0]);
            return !isNamed;
        }
        catch (Throwable var5) {
            LOGGER.info(Messages.MESSAGES.unableToUseResourceBundleAggregation(), new Object[0]);
            return false;
        }
    }

    private static class AggregateResourceBundle
    extends ResourceBundle {
        protected static final ResourceBundle.Control CONTROL = new AggregateResourceBundleControl();
        private final Properties properties;

        protected AggregateResourceBundle(Properties properties) {
            this.properties = properties;
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.properties.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            HashSet keySet = CollectionHelper.newHashSet();
            keySet.addAll(this.properties.stringPropertyNames());
            if (this.parent != null) {
                keySet.addAll(Collections.list(this.parent.getKeys()));
            }
            return Collections.enumeration(keySet);
        }
    }

    private static class AggregateResourceBundleControl
    extends ResourceBundle.Control {
        private AggregateResourceBundleControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (!"java.properties".equals(format)) {
                return super.newBundle(baseName, locale, format, loader, reload);
            }
            String resourceName = this.toBundleName(baseName, locale) + ".properties";
            Properties properties = this.load(resourceName, loader);
            return properties.size() == 0 ? null : new AggregateResourceBundle(properties);
        }

        private Properties load(String resourceName, ClassLoader loader) throws IOException {
            Properties aggregatedProperties = new Properties();
            Enumeration urls = (Enumeration)ValidatorBundleLocator.run((PrivilegedAction)GetResources.action((ClassLoader)loader, (String)resourceName));
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                Properties properties = new Properties();
                properties.load(url.openStream());
                aggregatedProperties.putAll((Map<?, ?>)properties);
            }
            return aggregatedProperties;
        }
    }
}

