package io.vertx.up.micro.follow;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.up.aiki.Ux;
import io.vertx.up.atom.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ipc.client.TunnelClient;
import io.vertx.up.tool.mirror.Instance;

import java.lang.reflect.Method;

/**
 * Future<Envelop> method(Envelop)
 */
public class FutureInvoker implements Invoker {

    private static final Annal LOGGER = Annal.get(FutureInvoker.class);

    @Override
    public void ensure(final Class<?> returnType,
                       final Class<?> paramCls) {
        // Verify
        final boolean valid =
                Future.class.isAssignableFrom(returnType) && paramCls == Envelop.class;
        InvokerUtil.verify(!valid, returnType, paramCls, this.getClass());
    }

    @Override
    @SuppressWarnings("unchecked")
    public void invoke(final Object proxy,
                       final Method method,
                       final Message<Envelop> message) {
        // Invoke directly
        final Envelop envelop = message.body();
        // Future<T>
        final Class<?> returnType = method.getReturnType();
        // Get T
        final Class<?> tCls = returnType.getComponentType();
        LOGGER.info(Info.MSG_FUTURE, this.getClass(), returnType, false);
        if (Envelop.class == tCls) {
            final Future<Envelop> result = Instance.invoke(proxy, method.getName(), envelop);
            result.setHandler(item -> message.reply(item.result()));
        } else {
            final Future tResult = Instance.invoke(proxy, method.getName(), envelop);
            tResult.setHandler(Ux.toHandler(message));
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void next(final Object proxy,
                     final Method method,
                     final Message<Envelop> message,
                     final Vertx vertx) {
        // Invoke directly
        final Envelop envelop = message.body();
        // Future<T>
        final Class<?> returnType = method.getReturnType();
        // Get T
        final Class<?> tCls = returnType.getComponentType();
        LOGGER.info(Info.MSG_FUTURE, this.getClass(), returnType, true);
        if (Envelop.class == tCls) {
            // Execute Future<Envelop>
            final Future<Envelop> future = Instance.invoke(proxy, method.getName(), envelop);
            future.compose(item -> TunnelClient.create(this.getClass())
                    .connect(vertx)
                    .connect(method)
                    .send(item))
                    .setHandler(Ux.toHandler(message));
        } else {
            final Future future = Instance.invoke(proxy, method.getName(), envelop);
            future.compose(item -> TunnelClient.create(this.getClass())
                    .connect(vertx)
                    .connect(method)
                    .send(Ux.to(item)))
                    .compose(item -> Future.succeededFuture(Ux.to(item)))
                    .setHandler(Ux.toHandler(message));
        }
    }
}
