/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import io.vertx.zero.atom.Mirror;
import io.vertx.zero.atom.Mojo;
import java.util.concurrent.ConcurrentMap;

class Query {
    private static final Annal LOGGER = Annal.get(Query.class);

    Query() {
    }

    static Inquiry getInquiry(JsonObject envelop, String pojo) {
        return (Inquiry)Fn.get((Object)Inquiry.create((JsonObject)new JsonObject()), () -> {
            JsonObject data = envelop.copy();
            if (StringUtil.isNil((String)pojo)) {
                return Inquiry.create((JsonObject)data);
            }
            Mojo mojo = Mirror.create(Query.class).mount(pojo).mojo();
            if (data.containsKey("projection")) {
                data.put("projection", Query.projection(data.getJsonArray("projection"), mojo));
            }
            if (data.containsKey("sorter")) {
                data.put("sorter", Query.sorter(data.getJsonArray("sorter"), mojo));
            }
            if (data.containsKey("criteria")) {
                data.put("criteria", Query.criteria(data.getJsonObject("criteria"), mojo));
            }
            LOGGER.info("[ ZERO ] ( Inquiry ) Processed metadata = {0}", new Object[]{data.encode()});
            return Inquiry.create((JsonObject)data);
        }, (Object[])new Object[]{envelop});
    }

    private static JsonArray sorter(JsonArray sorter, Mojo mojo) {
        JsonArray sorters = new JsonArray();
        ConcurrentMap mapping = mojo.getColumns();
        Fn.itJArray((JsonArray)sorter, String.class, (item, index) -> {
            String key;
            String string = key = item.contains(",") ? item.split(",")[0] : item;
            if (mapping.containsKey(key)) {
                String targetField = (String)mapping.get(key);
                if (item.contains(",")) {
                    sorters.add(targetField + "," + item.split(",")[1]);
                } else {
                    sorters.add(targetField + "," + "ASC");
                }
            } else {
                sorters.add(item);
            }
        });
        return sorters;
    }

    static JsonObject criteria(JsonObject criteria, Mojo mojo) {
        JsonObject criterias = new JsonObject();
        ConcurrentMap mapping = mojo.getColumns();
        for (String field : criteria.fieldNames()) {
            String key = field.contains(",") ? field.split(",")[0] : field;
            String targetField = "";
            if (!mapping.containsKey(key)) continue;
            targetField = field.contains(",") ? (String)mapping.get(key) + "," + field.split(",")[1] : (String)mapping.get(key);
            criterias.put(targetField, criteria.getValue(field));
        }
        return criterias;
    }

    private static JsonArray projection(JsonArray projections, Mojo mojo) {
        JsonArray result = new JsonArray();
        ConcurrentMap mapping = mojo.getRevert();
        Fn.itJArray((JsonArray)projections, String.class, (item, index) -> result.add(null == mapping.get(item) ? item : (String)mapping.get(item)));
        return result;
    }
}

