/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.tp.etcd.center.EtcdData;
import io.vertx.up.annotations.Worker;
import io.vertx.up.eon.em.MessageModel;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroHttpWorker;
import io.vertx.up.rs.Extractor;
import io.vertx.up.rs.config.WorkerExtractor;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.anima.Scatter;
import io.vertx.up.web.anima.Verticles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerScatter
implements Scatter<Vertx> {
    @Override
    public void connect(Vertx vertx) {
        Set<Class<?>> sources = ZeroAnno.getWorkers();
        if (sources.isEmpty()) {
            sources.add(ZeroHttpWorker.class);
        }
        Set<Class<?>> workers = this.getTargets(sources);
        Extractor extractor = (Extractor)Instance.instance(WorkerExtractor.class, (Object[])new Object[0]);
        ConcurrentHashMap options = new ConcurrentHashMap();
        for (Class<?> worker : workers) {
            DeploymentOptions option = (DeploymentOptions)extractor.extract(worker);
            options.put(worker, option);
            Verticles.deploy(vertx, worker, option, this.getLogger());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Fn.itSet((Set)workers, (clazz, index) -> {
            DeploymentOptions opt = (DeploymentOptions)options.get(clazz);
            Verticles.undeploy(vertx, clazz, opt, this.getLogger());
        })));
    }

    private Annal getLogger() {
        return Annal.get(this.getClass());
    }

    private Set<Class<?>> getTargets(Set<Class<?>> sources) {
        HashSet workers = new HashSet();
        for (Class<?> source : sources) {
            MessageModel model = (MessageModel)Instance.invoke((Object)source.getAnnotation(Worker.class), (String)"value", (Object[])new Object[0]);
            if (!this.getModel().contains(model)) continue;
            workers.add(source);
        }
        return workers;
    }

    protected Set<MessageModel> getModel() {
        HashSet<MessageModel> models = new HashSet<MessageModel>(){
            {
                this.add(MessageModel.REQUEST_RESPONSE);
            }
        };
        if (EtcdData.enabled()) {
            models.add(MessageModel.REQUEST_MICRO_WORKER);
        }
        return models;
    }
}

