/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.micro.config;

import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Ensurer;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.config.ServerVisitor;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.ServerConfigException;
import io.vertx.zero.marshal.Transformer;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.micro.config.HttpServerStrada;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HttpServerVisitor
implements ServerVisitor<HttpServerOptions> {
    private final transient Node<JsonObject> NODE = Node.infix((String)"server");
    protected final transient Transformer<HttpServerOptions> transformer = (Transformer)Instance.singleton(HttpServerStrada.class, (Object[])new Object[0]);

    public ConcurrentMap<Integer, HttpServerOptions> visit(String ... key) throws ZeroException {
        Ensurer.eqLength(this.getClass(), (int)0, (Object[])key);
        JsonObject data = (JsonObject)this.NODE.read();
        Fn.flingZero((null == data || !data.containsKey("server") ? 1 : 0) != 0, (Annal)this.getLogger(), ServerConfigException.class, (Object[])new Object[]{this.getClass(), null == data ? null : data.encode()});
        return this.visit(data.getJsonArray("server"));
    }

    private ConcurrentMap<Integer, HttpServerOptions> visit(JsonArray serverData) throws ZeroException {
        this.getLogger().info("[ ZERO ] The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{"server", this.getType(), serverData.encode()});
        Ruler.verify((String)"server", (JsonArray)serverData);
        ConcurrentHashMap<Integer, HttpServerOptions> map = new ConcurrentHashMap<Integer, HttpServerOptions>();
        this.extract(serverData, map);
        this.getLogger().info("[ ZERO ] ( node = {0}, type = {1} ) filtered configuration port set = {2}.", new Object[]{"server", this.getType(), map.keySet()});
        return map;
    }

    protected void extract(JsonArray serverData, ConcurrentMap<Integer, HttpServerOptions> map) {
        Fn.itJArray((JsonArray)serverData, JsonObject.class, (item, index) -> {
            if (this.isServer((JsonObject)item)) {
                int port = this.extractPort(item.getJsonObject("config"));
                HttpServerOptions options = (HttpServerOptions)this.transformer.transform(item);
                Fn.safeNull(() -> map.put(port, options), (Object[])new Object[]{port, options});
            }
        });
    }

    protected boolean isServer(JsonObject item) {
        return this.getType().match(item.getString("type"));
    }

    protected int extractPort(JsonObject config) {
        if (null != config) {
            return config.getInteger("port", Integer.valueOf(80));
        }
        return 80;
    }

    protected ServerType getType() {
        return ServerType.HTTP;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

