/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up;

import io.vertx.tp.etcd.center.EtcdData;
import io.vertx.up.Launcher;
import io.vertx.up.annotations.Up;
import io.vertx.up.boot.DansApplication;
import io.vertx.up.concurrent.Runner;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroLauncher;
import io.vertx.up.web.anima.AffluxScatter;
import io.vertx.up.web.anima.AgentScatter;
import io.vertx.up.web.anima.CodexScatter;
import io.vertx.up.web.anima.InfixScatter;
import io.vertx.up.web.anima.Scatter;
import io.vertx.up.web.anima.WorkerScatter;
import io.vertx.zero.config.ServerVisitor;
import io.vertx.zero.exception.EtcdNetworkException;
import io.vertx.zero.exception.MicroModeUpException;
import io.vertx.zero.exception.UpClassArgsException;
import io.vertx.zero.exception.UpClassInvalidException;
import io.vertx.zero.micro.config.DynamicVisitor;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VertxApplication {
    private static final Annal LOGGER = Annal.get(VertxApplication.class);
    private final transient Class<?> clazz;
    private transient ConcurrentMap<String, Annotation> annotationMap = new ConcurrentHashMap<String, Annotation>();

    private VertxApplication(Class<?> clazz) {
        Fn.flingUp((null == clazz ? 1 : 0) != 0, (Annal)LOGGER, UpClassArgsException.class, (Object[])new Object[]{this.getClass()});
        this.clazz = clazz;
        this.annotationMap = Anno.get(clazz);
        Fn.flingUp((!this.annotationMap.containsKey(Up.class.getName()) ? 1 : 0) != 0, (Annal)LOGGER, UpClassInvalidException.class, (Object[])new Object[]{this.getClass(), clazz.getName()});
    }

    public static void run(Class<?> clazz, Object ... args) {
        Fn.shuntRun(() -> {
            VertxApplication.ensureEtcd(clazz);
            if (VertxApplication.isGateway()) {
                DansApplication.run(clazz, new Object[0]);
            } else {
                new VertxApplication(clazz).run(args);
            }
        }, (Annal)LOGGER);
    }

    private static boolean isGateway() {
        HashSet apiScanned = new HashSet();
        Fn.flingUp(() -> {
            ServerVisitor visitor = (ServerVisitor)Instance.singleton(DynamicVisitor.class, (Object[])new Object[0]);
            apiScanned.addAll(((ConcurrentMap)visitor.visit(new String[]{ServerType.API.toString()})).keySet());
        }, (Annal)LOGGER);
        return !apiScanned.isEmpty();
    }

    private static void ensureEtcd(Class<?> clazz) {
        if (EtcdData.enabled()) {
            try {
                EtcdData.create(clazz);
            }
            catch (EtcdNetworkException ex) {
                Fn.flingUp((boolean)true, (Annal)LOGGER, MicroModeUpException.class, (Object[])new Object[]{clazz, ex.getMessage()});
            }
        }
    }

    private void run(Object ... args) {
        Launcher launcher = (Launcher)Instance.singleton(ZeroLauncher.class, (Object[])new Object[0]);
        launcher.start(vertx -> {
            Runner.run(() -> {
                Scatter scatter = (Scatter)Instance.singleton(AgentScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"agent-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Instance.singleton(WorkerScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"worker-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Instance.singleton(InfixScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
                scatter = (Scatter)Instance.singleton(AffluxScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"infix-afflux-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Instance.singleton(CodexScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"codex-engine-runner");
        });
    }
}

