/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception._500InternalServerException;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.Jackson;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.atom.Mirror;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class To {
    To() {
    }

    static <T> Future<T> toFuture(T entity) {
        return (Future)Fn.get((Object)Future.future(), () -> (Future)Fn.getSemi((boolean)(entity instanceof Throwable), null, () -> Future.failedFuture((Throwable)((Throwable)entity)), () -> Future.succeededFuture((Object)entity)), (Object[])new Object[]{entity});
    }

    static JsonObject toFilters(String[] columns, Supplier<Object> ... suppliers) {
        JsonObject filters = new JsonObject();
        int size = Math.min(columns.length, suppliers.length);
        for (int idx = 0; idx < size; ++idx) {
            String column = columns[idx];
            Supplier<Object> supplier = suppliers[idx];
            if (StringUtil.isNil((String)column) || !Objects.nonNull(supplier)) continue;
            filters.put(column, supplier.get());
        }
        return filters;
    }

    static <T> JsonObject toJson(T entity, String pojo) {
        return (JsonObject)Fn.get((Object)new JsonObject(), () -> (JsonObject)Fn.getSemi((boolean)StringUtil.isNil((String)pojo), null, () -> (JsonObject)Jackson.serializeJson((Object)entity), () -> Mirror.create(To.class).mount(pojo).connect((JsonObject)Jackson.serializeJson((Object)entity)).to().result()), (Object[])new Object[]{entity});
    }

    static <T> JsonObject toJson(T entity, Function<JsonObject, JsonObject> convert) {
        return (JsonObject)Fn.getSemi((null == convert ? 1 : 0) != 0, null, () -> To.toJson(entity, ""), () -> (JsonObject)convert.apply(To.toJson(entity, "")));
    }

    static <T> JsonArray toArray(List<T> list, Function<JsonObject, JsonObject> convert) {
        JsonArray array = new JsonArray();
        Observable.fromIterable(list).filter(Objects::nonNull).map(item -> To.toJson(item, convert)).subscribe(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    static <T> JsonArray toArray(List<T> list, String pojo) {
        JsonArray array = new JsonArray();
        Observable.fromIterable(list).filter(Objects::nonNull).map(item -> To.toJson(item, pojo)).subscribe(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    static <T> Envelop toEnvelop(T entity) {
        return (Envelop)Fn.get((Object)Envelop.ok(), () -> (Envelop)Fn.getSemi((boolean)(entity instanceof WebException), null, () -> Envelop.failure((WebException)entity), () -> {
            if (Envelop.class == entity.getClass()) {
                return (Envelop)entity;
            }
            return Envelop.success(entity);
        }), (Object[])new Object[]{entity});
    }

    static <T> Function<T, List<Future<T>>> toFutureList(Function<T, Future<T>> ... functions) {
        ArrayList futures = new ArrayList();
        return entity -> {
            Observable.fromArray((Object[])functions).map(function -> (Future)function.apply(entity)).subscribe(futures::add);
            return futures;
        };
    }

    static <T> Envelop toEnvelop(T entity, WebException error) {
        return (Envelop)Fn.get((Object)Envelop.failure(error), () -> Envelop.success(entity), (Object[])new Object[]{entity});
    }

    static WebException toError(Class<? extends WebException> clazz, Object ... args) {
        if (null == clazz || null == args) {
            return new _500InternalServerException(To.class, "clazz arg is null");
        }
        return (WebException)Instance.instance(clazz, (Object[])args);
    }

    static WebException toError(Class<?> clazz, Throwable error) {
        return (WebException)Fn.getSemi((boolean)(error instanceof WebException), null, () -> (WebException)error, () -> new _500InternalServerException(clazz, error.getMessage()));
    }

    static Envelop toEnvelop(Class<? extends WebException> clazz, Object ... args) {
        return Envelop.failure(To.toError(clazz, args));
    }

    static JsonObject toUnique(JsonArray array, String pojo) {
        return (JsonObject)Fn.getSemi((null == array || array.isEmpty() ? 1 : 0) != 0, null, () -> To.toJson(null, pojo), () -> To.toJson(array.getValue(0), pojo));
    }
}

