/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki.fun;

import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log {
    private final transient Annal logger;
    private transient String key;
    private static final ConcurrentMap<Integer, Annal> LOGGERS = new ConcurrentHashMap<Integer, Annal>();
    private static Log INSTANCE;

    public static Log create(Class<?> clazz) {
        if (null == INSTANCE) {
            INSTANCE = new Log(clazz);
        }
        return INSTANCE;
    }

    private Log(Class<?> clazz) {
        this.logger = (Annal)Fn.pool(LOGGERS, (Object)clazz.hashCode(), () -> Annal.get((Class)clazz));
    }

    public Log on(String key) {
        this.key = key;
        return this;
    }

    public Log info(Object ... args) {
        if (StringUtil.isNil((String)this.key)) {
            StringBuilder pattern = new StringBuilder();
            for (int idx = 0; idx < args.length; ++idx) {
                pattern.append("{").append(idx).append("}").append(" ");
            }
            this.logger.info(pattern.toString(), args);
        } else {
            this.logger.info(this.key, args);
        }
        this.key = null;
        return this;
    }
}

