/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki.fun;

import java.util.Objects;
import java.util.function.Function;

public class Tuple<T, U> {
    public final T first;
    public final U second;

    public Tuple(T t, U u) {
        this.first = Objects.requireNonNull(t);
        this.second = Objects.requireNonNull(u);
    }

    public Tuple<U, T> swap() {
        return new Tuple<U, T>(this.second, this.first);
    }

    public static <T> Tuple<T, T> swapIf(Tuple<T, T> t, Function<T, Function<T, Boolean>> p) {
        return p.apply(t.first).apply(t.second) != false ? t.swap() : t;
    }

    public String toString() {
        return String.format("(%s,%s)", this.first, this.second);
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Tuple that = (Tuple)o;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }
}

