/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.hold;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.up.log.Annal;

public class VirtualUser
implements User {
    private static final Annal LOGGER = Annal.get(VirtualUser.class);
    private final transient JsonObject principal;

    public VirtualUser(JsonObject principal) {
        this.principal = principal;
    }

    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        LOGGER.info("[ ZERO ] You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
        return this;
    }

    public User clearCache() {
        LOGGER.info("[ ZERO ] You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
        return null;
    }

    public JsonObject principal() {
        return this.principal;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        LOGGER.info("[ ZERO ] You have used virtual user, only principal = {0} is working.", new Object[]{this.principal});
    }
}

