/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.center;

import io.reactivex.Observable;
import io.vertx.core.ServidorOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.etcd.center.EtcdData;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.eon.em.EtcdPath;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.Net;
import io.vertx.up.tool.mirror.Types;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

public class ZeroRegistry {
    private static final String PATH_STATUS = "/zero/{0}/{1}/services/{2}:{3}:{4}";
    private static final String PATH_CATALOG = "/zero/{0}/{1}/services";
    private static final String ROUTE_TREE = "/zero/{0}/{1}/routes/{2}";
    private static final ConcurrentMap<String, ZeroRegistry> REGISTRY_MAP = new ConcurrentHashMap<String, ZeroRegistry>();
    private final transient Annal logger;
    private final transient EtcdData etcd;

    public static ZeroRegistry create(Class<?> useCls) {
        return (ZeroRegistry)Fn.poolThread(REGISTRY_MAP, () -> new ZeroRegistry(useCls));
    }

    private ZeroRegistry(Class<?> useCls) {
        this.etcd = EtcdData.create(useCls);
        this.logger = Annal.get(useCls);
    }

    public JsonArray getConfig() {
        return this.etcd.getConfig();
    }

    public Set<JsonObject> getData(EtcdPath etcdPath, String key, BiFunction<String, JsonArray, Set<JsonObject>> convert) {
        String path = MessageFormat.format(ROUTE_TREE, this.etcd.getApplication(), etcdPath.toString().toLowerCase(), key);
        this.logger.debug("[ ZERO ] ( Etcd Catalog ) Read the path {0} service lists.", new Object[]{path});
        String node = this.etcd.readData(path);
        HashSet<JsonObject> sets = new HashSet<JsonObject>();
        if (null != node) {
            JsonArray value = new JsonArray(node);
            sets.addAll((Collection<JsonObject>)convert.apply(key, value));
        }
        return sets;
    }

    public Set<String> getServices(EtcdPath etcdPath) {
        String path = MessageFormat.format(PATH_CATALOG, this.etcd.getApplication(), etcdPath.toString().toLowerCase());
        this.logger.debug("[ ZERO ] ( Etcd Catalog ) Read the path {0} service lists.", new Object[]{path});
        ConcurrentMap nodes = this.etcd.readDir(path, true);
        HashSet<String> sets = new HashSet<String>();
        Observable.fromIterable(nodes.entrySet()).filter(Objects::nonNull).filter(item -> Objects.nonNull(item.getKey()) && Objects.nonNull(item.getValue())).filter(item -> Etat.RUNNING == Types.fromStr(Etat.class, (String)((String)item.getValue()))).map(Map.Entry::getKey).subscribe(sets::add);
        return sets;
    }

    public void registryHttp(String service, HttpServerOptions options, Etat etat) {
        String path = MessageFormat.format(PATH_STATUS, this.etcd.getApplication(), EtcdPath.ENDPOINT.toString().toLowerCase(), service, Net.getIPv4(), String.valueOf(options.getPort()));
        this.logger.info("[ ZERO ] ( Etcd Center ) The status {0} of service {1} has been registried to {2}", new Object[]{service, etat, path});
        this.etcd.write(path, (Object)etat, 0);
    }

    public void registryRpc(ServidorOptions options, Etat etat) {
        String path = MessageFormat.format(PATH_STATUS, this.etcd.getApplication(), EtcdPath.IPC.toString().toLowerCase(), options.getName(), Net.getIPv4(), String.valueOf(options.getPort()));
        this.logger.info("[ ZERO ] ( Etcd Center ) The status {0} of service {1} has been registried to {2}", new Object[]{options.getName(), etat, path});
        this.etcd.write(path, (Object)etat, 0);
    }

    public void registryIpcs(ServidorOptions options, Set<String> ipcs) {
        String path = MessageFormat.format(ROUTE_TREE, this.etcd.getApplication(), EtcdPath.IPC.toString().toLowerCase(), MessageFormat.format("{0}:{1}:{2}", options.getName(), Net.getIPv4(), String.valueOf(options.getPort())));
        String host = Net.getIPv4();
        String endpoint = MessageFormat.format("grpc://{0}:{1}", host, String.valueOf(options.getPort()));
        StringBuilder builder = new StringBuilder();
        for (String ipc : ipcs) {
            builder.append("\n\t[ Up Rpc \u221a ] \t").append(ipc);
        }
        this.logger.info("[ ZERO ] ( Etcd Catalog ) The following routes has been push to:\n\t[ Up Rpc   ] <Application Name> = \"{0}\",\n\t[ Up Rpc   ] Configuration Rpc Point = {1}, \n\t[ Up Rpc   ] Service Name = {2},\n\t[ Up Rpc   ] Ipc Channel = {3}\n\t[ Up Rpc   ] Ipc Address = {4}\n\t[ Up Rpc   ] \u221a Successfully to registered IPCs, wait for community......SUCCESS \u221a", new Object[]{this.etcd.getApplication(), path, options.getName(), endpoint, builder.toString()});
        JsonArray routeData = new JsonArray();
        Observable.fromIterable(ipcs).subscribe(arg_0 -> ((JsonArray)routeData).add(arg_0));
        this.etcd.write(path, (Object)routeData, 0);
    }

    public void registryRoute(String name, HttpServerOptions options, Set<String> routes) {
        String path = MessageFormat.format(ROUTE_TREE, this.etcd.getApplication(), EtcdPath.ENDPOINT.toString().toLowerCase(), MessageFormat.format("{0}:{1}:{2}", name, Net.getIPv4(), String.valueOf(options.getPort())));
        String host = Net.getIPv4();
        String endpoint = MessageFormat.format("http://{0}:{1}", host, String.valueOf(options.getPort()));
        StringBuilder builder = new StringBuilder();
        for (String route : routes) {
            builder.append("\n\t[ Up Micro ] \t").append(route);
        }
        this.logger.info("[ ZERO ] ( Etcd Catalog ) The following routes has been push to:\n\t[ Up Micro ] <Application Name> = \"{0}\",\n\t[ Up Micro ] Configuration Path = {1}, \n\t[ Up Micro ] Service Name = {2},\n\t[ Up Micro ] EndPoint = {3}\n\t[ Up Micro ] Route Uris = {4}\n\t[ Up Micro ] \u221a Successfully to registered Routes, wait for discovery......SUCCESS \u221a", new Object[]{this.etcd.getApplication(), path, name, endpoint, builder.toString()});
        JsonArray routeData = new JsonArray();
        Observable.fromIterable(routes).subscribe(arg_0 -> ((JsonArray)routeData).add(arg_0));
        this.etcd.write(path, (Object)routeData, 0);
    }
}

