/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.matcher;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.servicediscovery.Record;
import io.vertx.up.micro.matcher.Arithmetic;
import io.vertx.up.micro.matcher.RegexPath;
import io.vertx.up.tool.StringUtil;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class CommonArithmetic
implements Arithmetic {
    @Override
    public Record search(List<Record> records, RoutingContext context) {
        HttpServerRequest request = context.request();
        String uri = request.uri();
        Optional<Record> hitted = records.stream().filter(record -> this.isMatch(uri, (Record)record)).findAny();
        return hitted.orElse(null);
    }

    private boolean isMatch(String uri, Record record) {
        JsonObject data = record.getMetadata();
        boolean match = false;
        if (data.containsKey("path")) {
            String path = data.getString("path");
            if (!StringUtil.isNil((String)path) && path.contains(":")) {
                Pattern pattern = RegexPath.createRegex(path);
                match = pattern.matcher(uri).matches();
            } else {
                match = path.equalsIgnoreCase(uri);
            }
        }
        return match;
    }
}

