/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ssl.client;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.quiz.core.tls.Trust;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ssl.TrustPipe;
import java.util.function.Supplier;

public class PemTrust
implements TrustPipe<JsonObject> {
    private static final Annal LOGGER = Annal.get(PemTrust.class);
    private static final String PATH_CERT = "cert";

    @Override
    public Handler<ClientOptionsBase> parse(JsonObject options) {
        return (Handler)Fn.get(() -> {
            PemTrustOptions pem = (PemTrustOptions)Fn.getSemi((!options.containsKey(PATH_CERT) ? 1 : 0) != 0, (Annal)LOGGER, (Supplier)Trust.CLIENT_PEM, () -> new PemTrustOptions().addCertPath(PATH_CERT));
            return option -> option.setSsl(true).setUseAlpn(true).setPemTrustOptions(pem).setOpenSslEngineOptions(new OpenSSLEngineOptions());
        }, (Object[])new Object[]{options});
    }
}

