/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.redis;

import io.vertx.core.Vertx;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.func.Fn;
import io.vertx.up.plugin.Infix;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin
public class RedisInfix
implements Infix {
    private static final String NAME = "ZERO_REDIS_POOL";
    private static final ConcurrentMap<String, RedisClient> CLIENTS = new ConcurrentHashMap<String, RedisClient>();

    private static void initInternal(Vertx vertx, String name) {
        Fn.pool(CLIENTS, (Object)name, () -> (RedisClient)Infix.init((String)"redis", config -> RedisClient.create((Vertx)vertx, (RedisOptions)new RedisOptions(config)), RedisInfix.class));
    }

    public static void init(Vertx vertx) {
        RedisInfix.initInternal(vertx, NAME);
    }

    public RedisClient get() {
        return RedisInfix.getClient();
    }

    public static RedisClient getClient() {
        return (RedisClient)CLIENTS.get(NAME);
    }
}

