/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Aim;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.Sentry;
import io.vertx.up.rs.dispatch.ModeSplitter;
import io.vertx.up.rs.dispatch.StandardVerifier;
import io.vertx.up.rs.router.Hub;
import io.vertx.up.rs.router.MediaHub;
import io.vertx.up.rs.router.Pool;
import io.vertx.up.rs.router.UriHub;
import io.vertx.up.rs.router.Verifier;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.failure.CommonEndurer;
import java.util.Set;

public class EventAxis
implements Axis<Router> {
    private static final Annal LOGGER = Annal.get(EventAxis.class);
    private static final Set<Event> EVENTS = ZeroAnno.getEvents();
    private final transient ModeSplitter splitter = (ModeSplitter)Fn.poolThread(Pool.THREADS, () -> (ModeSplitter)Instance.instance(ModeSplitter.class, (Object[])new Object[0]));
    private final transient Sentry<RoutingContext> verifier = (Sentry)Fn.poolThread(Pool.VERIFIERS, () -> (Sentry)Instance.instance(StandardVerifier.class, (Object[])new Object[0]));

    @Override
    public void mount(Router router) {
        EVENTS.forEach(event -> Fn.safeSemi((null == event ? 1 : 0) != 0, (Annal)LOGGER, () -> LOGGER.warn("[ ZERO ] ( {0} ) The system found \"null\" event in the queue. ", new Object[]{this.getClass().getName()}), () -> {
            Verifier.verify(event);
            Route route = router.route();
            Hub hub = (Hub)Fn.poolThread(Pool.URIHUBS, () -> (Hub)Instance.instance(UriHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            hub = (Hub)Fn.poolThread(Pool.MEDIAHUBS, () -> (Hub)Instance.instance(MediaHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            Depot depot = Depot.create(event);
            Aim<RoutingContext> aim = this.splitter.distribute((Event)event);
            route.handler(this.verifier.signal(depot)).handler(aim.attack((Event)event)).failureHandler(CommonEndurer.create());
        }));
    }
}

