/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.provider;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.up.aiki.Ux;
import io.vertx.up.exception._401JwtAudientException;
import io.vertx.up.exception._401JwtExecutorException;
import io.vertx.up.exception._401JwtExpiredException;
import io.vertx.up.exception._401JwtIssuerException;
import io.vertx.up.exception._500JwtRuntimeException;
import io.vertx.up.secure.provider.JwtAuth;
import java.util.Collections;
import java.util.function.Function;

public class JwtAuthProvider
implements JwtAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt;
    private final String permissionsClaimKey;
    private final JWTOptions jwtOptions;
    private final Function<JsonObject, Future<Boolean>> executor;

    public JwtAuthProvider(Vertx vertx, JWTAuthOptions config, Function<JsonObject, Future<Boolean>> executor) {
        this.executor = executor;
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.jwtOptions = config.getJWTOptions();
        this.jwt = Ux.Jwt.create(config, arg_0 -> ((FileSystem)vertx.fileSystem()).readFileBlocking(arg_0));
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        Future future = null == this.executor ? this.authorize(authInfo) : this.executor.apply(authInfo).compose(result -> {
            if (result.booleanValue()) {
                return this.authorize(authInfo);
            }
            return Future.failedFuture((Throwable)((Object)new _401JwtExecutorException(this.getClass(), authInfo.getString("jwt"))));
        });
        future.setHandler(resultHandler);
    }

    private Future<User> authorize(JsonObject authInfo) {
        try {
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            if (this.jwt.isExpired(payload, this.jwtOptions)) {
                return Future.failedFuture((Throwable)((Object)new _401JwtExpiredException(this.getClass(), payload)));
            }
            if (this.jwtOptions.getAudience() != null) {
                JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                    return Future.failedFuture((Throwable)((Object)new _401JwtAudientException(this.getClass(), Json.encode((Object)this.jwtOptions.getAudience()))));
                }
            }
            if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
                return Future.failedFuture((Throwable)((Object)new _401JwtIssuerException(this.getClass(), payload.getString("iss"))));
            }
            return Future.succeededFuture((Object)new JWTUser(payload, this.permissionsClaimKey));
        }
        catch (RuntimeException var5) {
            return Future.failedFuture((Throwable)((Object)new _500JwtRuntimeException(this.getClass(), var5)));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject _claims = claims.copy();
        if (options.getPermissions() != null && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, new JsonArray(options.getPermissions()));
        }
        return this.jwt.sign(_claims, options);
    }
}

