/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Pack;
import io.vertx.up.web.origin.AffluxInquirer;
import io.vertx.up.web.origin.AgentInquirer;
import io.vertx.up.web.origin.EndPointInquirer;
import io.vertx.up.web.origin.EventInquirer;
import io.vertx.up.web.origin.FilterInquirer;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.up.web.origin.IpcInquirer;
import io.vertx.up.web.origin.PointerInquirer;
import io.vertx.up.web.origin.QueueInquirer;
import io.vertx.up.web.origin.ReceiptInquirer;
import io.vertx.up.web.origin.WallInquirer;
import io.vertx.up.web.origin.WorkerInquirer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ZeroAnno {
    private static final Annal LOGGER = Annal.get(ZeroAnno.class);
    private static final Set<Class<?>> ENDPOINTS = new HashSet();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>> PLUGINS = new ConcurrentHashMap();
    private static final Set<Receipt> RECEIPTS = new HashSet<Receipt>();
    private static final Set<Event> EVENTS = new HashSet<Event>();
    private static final ConcurrentMap<String, Set<Event>> FILTERS = new ConcurrentHashMap<String, Set<Event>>();
    private static final ConcurrentMap<ServerType, List<Class<?>>> AGENTS = new ConcurrentHashMap();
    private static final Set<Class<?>> WORKERS = new HashSet();
    private static final Set<Cliff> WALLS = new TreeSet<Cliff>();
    private static final ConcurrentMap<String, Method> IPCS = new ConcurrentHashMap<String, Method>();
    private static final Set<Class<?>> POINTER = new HashSet();

    public static ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>> getPlugins() {
        return PLUGINS;
    }

    public static ConcurrentMap<ServerType, List<Class<?>>> getAgents() {
        return AGENTS;
    }

    public static Set<Class<?>> getInjects() {
        return POINTER;
    }

    public static Set<Class<?>> getWorkers() {
        return WORKERS;
    }

    public static Set<Receipt> getReceipts() {
        return RECEIPTS;
    }

    public static Set<Class<?>> getEndpoints() {
        return ENDPOINTS;
    }

    public static ConcurrentMap<String, Method> getIpcs() {
        return IPCS;
    }

    public static Set<Event> getEvents() {
        return EVENTS;
    }

    public static ConcurrentMap<String, Set<Event>> getFilters() {
        return FILTERS;
    }

    public static Set<Cliff> getWalls() {
        return WALLS;
    }

    static {
        Set clazzes = Pack.getClasses(null, (String[])new String[0]);
        Inquirer inquirer = (Inquirer)Instance.singleton(EndPointInquirer.class, (Object[])new Object[0]);
        ENDPOINTS.addAll((Collection)inquirer.scan(clazzes));
        Fn.safeSemi((!ENDPOINTS.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer event = (Inquirer)Instance.singleton(EventInquirer.class, (Object[])new Object[0]);
            EVENTS.addAll((Collection)event.scan(ENDPOINTS));
        });
        Inquirer walls = (Inquirer)Instance.singleton(WallInquirer.class, (Object[])new Object[0]);
        WALLS.addAll((Collection)walls.scan(clazzes));
        Inquirer filters = (Inquirer)Instance.singleton(FilterInquirer.class, (Object[])new Object[0]);
        FILTERS.putAll((Map)filters.scan(clazzes));
        inquirer = (Inquirer)Instance.singleton(QueueInquirer.class, (Object[])new Object[0]);
        Set queues = (Set)inquirer.scan(clazzes);
        Fn.safeSemi((!queues.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer receipt = (Inquirer)Instance.singleton(ReceiptInquirer.class, (Object[])new Object[0]);
            RECEIPTS.addAll((Collection)receipt.scan(queues));
        });
        Fn.safeSemi((boolean)IPCS.isEmpty(), (Annal)LOGGER, () -> {
            Inquirer ipc = (Inquirer)Instance.singleton(IpcInquirer.class, (Object[])new Object[0]);
            IPCS.putAll((Map)ipc.scan(clazzes));
        });
        Inquirer agent = (Inquirer)Instance.singleton(AgentInquirer.class, (Object[])new Object[0]);
        AGENTS.putAll((Map)agent.scan(clazzes));
        Inquirer pointer = (Inquirer)Instance.singleton(PointerInquirer.class, (Object[])new Object[0]);
        POINTER.addAll((Collection)pointer.scan(clazzes));
        Inquirer worker = (Inquirer)Instance.singleton(WorkerInquirer.class, (Object[])new Object[0]);
        WORKERS.addAll((Collection)worker.scan(clazzes));
        Inquirer afflux = (Inquirer)Instance.singleton(AffluxInquirer.class, (Object[])new Object[0]);
        PLUGINS.putAll((Map)afflux.scan(clazzes));
    }
}

