/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.origin;

import io.reactivex.Observable;
import io.vertx.core.eventbus.Message;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.zero.exception.WorkerConflictException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class QueueInquirer
implements Inquirer<Set<Class<?>>> {
    private static final Annal LOGGER = Annal.get(QueueInquirer.class);

    @Override
    public Set<Class<?>> scan(Set<Class<?>> classes) {
        Set<Class<?>> queues = classes.stream().filter(item -> item.isAnnotationPresent(Queue.class)).collect(Collectors.toSet());
        LOGGER.info("[ ZERO ] ( {0} Queue ) The Zero system has found {0} components of @Queue.", new Object[]{queues.size()});
        this.ensure(queues);
        return queues;
    }

    private void ensure(Set<Class<?>> clazzes) {
        HashSet methodSet = new HashSet();
        Observable.fromIterable(clazzes).map(Class::getDeclaredMethods).flatMap(Observable::fromArray).filter(method -> method.isAnnotationPresent(Address.class)).subscribe(method -> {
            Class<?> returnType = method.getReturnType();
            Class<?> parameterTypes = method.getParameterTypes()[0];
            if (Message.class.isAssignableFrom(parameterTypes)) {
                Fn.flingUp((Void.TYPE != returnType && Void.class != returnType ? 1 : 0) != 0, (Annal)LOGGER, WorkerConflictException.class, (Object[])new Object[]{this.getClass(), method});
            } else {
                Fn.flingUp((Void.TYPE == returnType || Void.class == returnType ? 1 : 0) != 0, (Annal)LOGGER, WorkerConflictException.class, (Object[])new Object[]{this.getClass(), method});
            }
        });
    }
}

