/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.thread;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Extractor;
import io.vertx.up.rs.config.EventExtractor;
import io.vertx.up.tool.mirror.Instance;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EndPointThread
extends Thread {
    private static final Annal LOGGER = Annal.get(EndPointThread.class);
    private final Set<Event> events = new HashSet<Event>();
    private final transient Extractor<Set<Event>> extractor = (Extractor)Instance.instance(EventExtractor.class, (Object[])new Object[0]);
    private final transient Class<?> reference;

    public EndPointThread(Class<?> clazz) {
        this.setName("zero-endpoint-scanner-" + this.getId());
        this.reference = clazz;
    }

    @Override
    public void run() {
        if (null != this.reference) {
            this.events.addAll((Collection<Event>)this.extractor.extract(this.reference));
            LOGGER.info("[ ZERO ] ( {1} Event ) The endpoint {0} scanned {1} events of Event, will be mounted to routing system.", new Object[]{this.reference.getName(), this.events.size()});
        }
    }

    public Set<Event> getEvents() {
        return this.events;
    }
}

