package io.vertx.up.rs.router;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Axis;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class FilterAxis implements Axis<Router> {
    private static final Annal LOGGER = Annal.get(FilterAxis.class);

    private static final ConcurrentMap<String, Set<Event>> FILTERS =
            ZeroAnno.getFilters();

    @Override
    public void mount(final Router router) {
        // Extract Event foreach
        FILTERS.forEach((path, events) -> events.forEach(event -> Fn.safeSemi(null == event, LOGGER,
                () -> LOGGER.warn(Info.NULL_EVENT, this.getClass().getName()),
                () -> {
                    // Path for filter
                    final Route route = router.route();

                    Hub<Route> hub = Fn.poolThread(Pool.URIHUBS,
                            () -> Instance.instance(UriHub.class));
                    hub.mount(route, event);
                    // Consumes/Produces
                    hub = Fn.poolThread(Pool.MEDIAHUBS,
                            () -> Instance.instance(MediaHub.class));
                    hub.mount(route, event);
                    // Filter Handler execution
                    route.handler(context -> {
                        // Execute method
                        final Method method = event.getAction();
                        final Object proxy = event.getProxy();
                        // Call
                        this.execute(context, proxy, method);
                    });
                }))
        );
    }

    private void execute(final RoutingContext context, final Object proxy, final Method method) {
        Fn.safeNull(() -> Fn.safeJvm(() -> {
            // Init context;
            Instance.invoke(proxy, "init", context);
            // Extract Request/Response
            final HttpServerRequest request = context.request();
            final HttpServerResponse response = context.response();
            method.invoke(proxy, request, response);

            // Check whether called next or response
            if (!response.ended()) {
                context.next();
            }
        }, LOGGER), method, proxy);
    }
}
