/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.job;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.job.JobClient;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.center.Agha;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class JobClientImpl
implements JobClient {
    private static final Annal LOGGER = Annal.get(JobClientImpl.class);
    private final transient Vertx vertx;
    private final transient JsonObject config;

    JobClientImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public JobClient start(String code, Handler<AsyncResult<Long>> handler) {
        Mission mission = JobPool.get(code);
        if (Objects.nonNull(mission)) {
            Agha agha = Agha.get(mission.getType());
            Ut.contract((Object)agha, Vertx.class, (Object)this.vertx);
            Future<Long> future = agha.begin(mission);
            handler.handle(future);
        } else {
            LOGGER.info("( JobClient ) The pool could not find job of code = `{0}`", new Object[]{code});
        }
        return this;
    }

    @Override
    public JobClient stop(Long timerId, Handler<AsyncResult<Boolean>> handler) {
        JobPool.stop(timerId);
        handler.handle((Object)Future.succeededFuture((Object)Boolean.TRUE));
        this.vertx.cancelTimer(timerId.longValue());
        return this;
    }

    @Override
    public JobClient resume(Long timeId, Handler<AsyncResult<Long>> handler) {
        JobPool.resume(timeId);
        String code = JobPool.code(timeId);
        return this.start(code, handler);
    }
}

