/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.job;

import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class JobPool {
    private static final Annal LOGGER = Annal.get(JobPool.class);
    private static final ConcurrentMap<String, Mission> JOBS = new ConcurrentHashMap<String, Mission>();
    private static final ConcurrentMap<Long, String> RUNNING = new ConcurrentHashMap<Long, String>();

    public static ConcurrentMap<String, Mission> mapJobs() {
        return JOBS;
    }

    public static ConcurrentMap<Long, String> mapRuns() {
        return RUNNING;
    }

    public static void put(Set<Mission> missions) {
        missions.forEach(mission -> JOBS.put(mission.getCode(), (Mission)mission));
    }

    public static Mission get(String code, Supplier<Mission> supplier) {
        return JOBS.getOrDefault(code, supplier.get());
    }

    public static Mission get(String code) {
        return (Mission)JOBS.get(code);
    }

    public static List<Mission> get() {
        return JOBS.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String code(Long timeId) {
        return (String)RUNNING.get(timeId);
    }

    public static Long timeId(String code) {
        return RUNNING.keySet().stream().filter(key -> code.equals(RUNNING.get(key))).findFirst().orElse(null);
    }

    public static void remove(String code) {
        JOBS.remove(code);
    }

    public static void save(Mission mission) {
        JOBS.put(mission.getCode(), mission);
    }

    public static boolean valid(Mission mission) {
        return JOBS.containsKey(mission.getCode());
    }

    public static void mount(Long timeId, String code) {
        RUNNING.put(timeId, code);
    }

    public static void start(Long timeId, String code) {
        JobPool.uniform(code, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.RUNNING == status) {
                LOGGER.info("( Job ) The job {0} has already been running !!!", new Object[]{code});
            } else if (JobStatus.ERROR == status) {
                LOGGER.warn("( Job ) The job {0} met error last time, please contact administrator and try to resume.", new Object[]{code});
            } else if (JobStatus.STARTING == status) {
                LOGGER.warn("( Job ) The job {0} is booting, please preparing for READY", new Object[]{code});
            } else {
                if (JobStatus.STOPPED == status) {
                    ((Mission)JOBS.get(code)).setStatus(JobStatus.READY);
                }
                RUNNING.put(timeId, code);
            }
        });
    }

    public static void stop(Long timeId) {
        JobPool.uniform(timeId, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.RUNNING == status || JobStatus.READY == status) {
                RUNNING.remove(timeId);
                mission.setStatus(JobStatus.STOPPED);
            } else {
                LOGGER.info("( Job ) The job {0} is not running, the status is = {1}", new Object[]{mission.getCode(), status});
            }
        });
    }

    public static void resume(Long timeId) {
        JobPool.uniform(timeId, (Mission mission) -> {
            JobStatus status = mission.getStatus();
            if (JobStatus.ERROR == status) {
                RUNNING.put(timeId, mission.getCode());
                mission.setStatus(JobStatus.READY);
            }
        });
    }

    private static void uniform(Long timeId, Consumer<Mission> consumer) {
        String code = (String)RUNNING.get(timeId);
        if (Ut.isNil((String)code)) {
            LOGGER.info("( Job ) The timeId {0} does not exist in RUNNING pool of jobs.", new Object[]{timeId});
        } else {
            JobPool.uniform(code, consumer);
        }
    }

    private static void uniform(String code, Consumer<Mission> consumer) {
        Mission mission = (Mission)JOBS.get(code);
        if (Objects.nonNull(mission)) {
            consumer.accept(mission);
        }
    }
}

