/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up;

import io.vertx.tp.plugin.shared.MapInfix;
import io.vertx.up.Launcher;
import io.vertx.up.MicroApplication;
import io.vertx.up.annotations.Up;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.Anno;
import io.vertx.up.runtime.Runner;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.runtime.ZeroHeart;
import io.vertx.up.uca.registry.Uddi;
import io.vertx.up.uca.registry.UddiRegistry;
import io.vertx.up.uca.web.ZeroLauncher;
import io.vertx.up.uca.web.anima.AffluxScatter;
import io.vertx.up.uca.web.anima.AgentScatter;
import io.vertx.up.uca.web.anima.CodexScatter;
import io.vertx.up.uca.web.anima.InfixScatter;
import io.vertx.up.uca.web.anima.Scatter;
import io.vertx.up.uca.web.anima.WorkerScatter;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.UpClassArgsException;
import io.vertx.zero.exception.UpClassInvalidException;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentMap;

public class VertxApplication {
    private static final Annal LOGGER = Annal.get(VertxApplication.class);
    private final transient Class<?> clazz;
    private final transient ConcurrentMap<String, Annotation> annotationMap;

    private VertxApplication(Class<?> clazz) {
        Fn.out((null == clazz ? 1 : 0) != 0, UpClassArgsException.class, (Object[])new Object[]{this.getClass()});
        this.clazz = clazz;
        this.annotationMap = Anno.get(clazz);
        Fn.out((!this.annotationMap.containsKey(Up.class.getName()) ? 1 : 0) != 0, UpClassInvalidException.class, (Object[])new Object[]{this.getClass(), null == this.clazz ? null : this.clazz.getName()});
    }

    public static void run(Class<?> clazz, Object ... args) {
        Fn.onRun(() -> {
            VertxApplication.ensureEtcd(clazz);
            ZeroHeart.init();
            ZeroAnno.prepare();
            if (ZeroHeart.isGateway()) {
                MicroApplication.run(clazz, new Object[0]);
            } else {
                new VertxApplication(clazz).run(args);
            }
        }, (Annal)LOGGER);
    }

    private static void ensureEtcd(Class<?> clazz) {
        if (ZeroHeart.isEtcd()) {
            UddiRegistry registry = Uddi.registry(VertxApplication.class);
            registry.initialize(clazz);
        }
    }

    private void run(Object ... args) {
        Launcher launcher = (Launcher)Ut.singleton(ZeroLauncher.class, (Object[])new Object[0]);
        launcher.start(vertx -> {
            if (ZeroHeart.isShared()) {
                MapInfix.init(vertx);
            }
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(AgentScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"agent-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(WorkerScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"worker-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(InfixScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
                scatter = (Scatter)Ut.singleton(AffluxScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"infix-afflux-runner");
            Runner.run(() -> {
                Scatter scatter = (Scatter)Ut.singleton(CodexScatter.class, (Object[])new Object[0]);
                scatter.connect(vertx);
            }, (String)"codex-engine-runner");
        });
    }
}

