/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.ActFile;
import io.vertx.up.commune.ActJArray;
import io.vertx.up.commune.ActJObject;
import io.vertx.up.commune.ActMapping;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.DualMapping;
import io.vertx.up.fn.Fn;
import io.vertx.zero.exception.ActSpecificationException;
import java.io.File;
import java.io.Serializable;

public class ActIn
extends ActMapping
implements Serializable {
    private final transient Envelop envelop;
    private final boolean isBatch;
    private final transient ActFile file;
    private transient ActJObject json;
    private transient ActJArray jarray;
    private transient Record definition;
    private transient DualMapping mapping;

    public ActIn(Envelop envelop) {
        this.envelop = envelop;
        JsonObject data = (JsonObject)envelop.data();
        if (data.containsKey("$$__BODY__$$")) {
            Object value = data.getValue("$$__BODY__$$");
            if (value instanceof JsonArray) {
                this.jarray = new ActJArray(envelop);
                this.isBatch = true;
            } else {
                this.json = new ActJObject(envelop);
                this.isBatch = false;
            }
        } else {
            this.json = new ActJObject(envelop);
            this.isBatch = false;
        }
        JsonArray stream = data.getJsonArray("$$_STREAM__$$");
        this.file = new ActFile(stream);
    }

    public ActIn bind(DualMapping mapping) {
        this.mapping = mapping;
        return this;
    }

    public Envelop getEnvelop() {
        return this.envelop;
    }

    public JsonObject getJObject() {
        if (this.isBatch) {
            return new JsonObject();
        }
        return this.json.getJson(this.mapping);
    }

    public JsonArray getJArray() {
        if (this.isBatch) {
            return this.jarray.getJson(this.mapping);
        }
        return new JsonArray();
    }

    public JsonObject getQuery() {
        Fn.outUp((boolean)this.isBatch, ActSpecificationException.class, (Object[])new Object[]{this.getClass(), this.isBatch});
        return this.json.getQuery();
    }

    public Record getRecord() {
        Fn.outUp((boolean)this.isBatch, ActSpecificationException.class, (Object[])new Object[]{this.getClass(), this.isBatch});
        return this.json.getRecord(this.definition, this.mapping);
    }

    public File[] getFiles() {
        return this.file.getFiles();
    }

    public Record[] getRecords() {
        Fn.outUp((!this.isBatch ? 1 : 0) != 0, ActSpecificationException.class, (Object[])new Object[]{this.getClass(), this.isBatch});
        return this.jarray.getRecords(this.definition, this.mapping);
    }

    public Record getDefinition() {
        return this.definition;
    }

    public String appId() {
        MultiMap paramMap = this.envelop.headers();
        return paramMap.get("X-App-Id");
    }

    public String sigma() {
        MultiMap paramMap = this.envelop.headers();
        return paramMap.get("X-Sigma");
    }

    public void connect(Record definition) {
        this.definition = definition;
    }
}

