/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.commune.ActMapping;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.DualMapping;
import io.vertx.up.eon.Constants;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

class ActJObject
extends ActMapping
implements Serializable {
    private final transient JsonObject data = new JsonObject();
    private final transient JsonObject query = new JsonObject();

    ActJObject(Envelop envelop) {
        JsonObject header = envelop.headersX();
        this.data.mergeIn(header, true);
        this.partData(envelop);
    }

    private void partData(Envelop envelop) {
        JsonObject rawJson = (JsonObject)envelop.data();
        if (!Ut.isNil((JsonObject)rawJson)) {
            JsonObject body;
            long counter = rawJson.fieldNames().stream().filter(Constants.INDEXES::containsValue).count();
            if (0L < counter) {
                JsonObject found = rawJson.fieldNames().stream().filter(Objects::nonNull).map(arg_0 -> ((JsonObject)rawJson).getValue(arg_0)).filter(value -> value instanceof JsonObject).map(item -> (JsonObject)item).findFirst().orElse(null);
                body = null == found ? new JsonObject() : found.copy();
            } else {
                body = rawJson.copy();
                JsonObject cross = new JsonObject();
                if (body.containsKey("$$__BODY__$$")) {
                    JsonObject inputData = body.copy();
                    body.fieldNames().stream().filter(field -> !"$$__BODY__$$".equals(field)).forEach(field -> this.data.put(field, inputData.getValue(field)));
                    cross = body.getJsonObject("$$__BODY__$$");
                }
                if (!Ut.isNil((JsonObject)cross)) {
                    body.clear();
                    body.mergeIn(cross, true);
                }
            }
            if (body.containsKey("criteria") || body.containsKey("projection")) {
                Arrays.stream(Qr.KEY_QUERY).filter(field -> Objects.nonNull(body.getValue(field))).forEach(field -> {
                    this.query.put(field, body.getValue(field));
                    body.remove(field);
                });
            }
            if (Ut.notNil((JsonObject)this.query) && !this.query.containsKey("criteria")) {
                this.query.put("criteria", new JsonObject());
            }
            if (Ut.notNil((JsonObject)body)) {
                this.data.mergeIn(body.copy(), true);
            }
        }
    }

    public JsonObject getQuery() {
        return this.query;
    }

    Record getRecord(Record definition, DualMapping mapping) {
        return this.getRecord(this.data, definition, mapping);
    }

    JsonObject getJson(DualMapping mapping) {
        if (this.isBefore(mapping)) {
            return this.mapper().in(this.data, mapping.child());
        }
        return this.data;
    }
}

