/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.DualMapping;
import io.vertx.up.eon.em.MappingMode;
import io.vertx.up.uca.adminicle.FieldMapper;
import io.vertx.up.uca.adminicle.Mapper;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

public abstract class ActMapping
implements Serializable {
    private final transient Mapper mapper = new FieldMapper();

    protected Record getRecord(Object input, Record definition, DualMapping mapping) {
        JsonObject dataRef;
        Record record = definition.createNew();
        if (input instanceof String) {
            String key = (String)input;
            record.key((Object)key);
        } else if (input instanceof JsonObject && Ut.notNil((JsonObject)(dataRef = (JsonObject)input))) {
            if (this.isBefore(mapping)) {
                JsonObject normalized = this.mapper.in(dataRef, mapping.child());
                record.set(normalized);
            } else {
                record.set(dataRef.copy());
            }
        }
        return record;
    }

    protected boolean isBefore(DualMapping mapping) {
        if (Objects.isNull(mapping)) {
            return false;
        }
        if (MappingMode.BEFORE != mapping.getMode() && MappingMode.AROUND != mapping.getMode()) {
            return false;
        }
        return mapping.valid();
    }

    protected boolean isAfter(DualMapping mapping) {
        if (Objects.isNull(mapping)) {
            return false;
        }
        if (MappingMode.AFTER != mapping.getMode() && MappingMode.AROUND != mapping.getMode()) {
            return false;
        }
        return mapping.valid();
    }

    protected Mapper mapper() {
        return this.mapper;
    }
}

