/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune.envelop;

import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.envelop.Rib;
import io.vertx.up.eon.Constants;
import io.vertx.up.util.Ut;
import java.util.Objects;

class RibData {
    RibData() {
    }

    static <T> T get(JsonObject data) {
        if (Objects.isNull(data) || !data.containsKey("data")) {
            return null;
        }
        Object value = data.getValue("data");
        if (Objects.isNull(value)) {
            return null;
        }
        return (T)value;
    }

    static <T> T get(JsonObject data, Class<?> clazz) {
        T reference = null;
        if (data.containsKey("data")) {
            Object value = data.getValue("data");
            reference = Rib.deserialize(value, clazz);
        }
        return reference;
    }

    static JsonObject getBody(JsonObject data) {
        return RibData.getData(data, null);
    }

    static <T> T get(JsonObject data, Class<?> clazz, Integer index) {
        JsonObject raw;
        T reference = null;
        if (data.containsKey("data") && !Ut.isNil((JsonObject)(raw = data.getJsonObject("data")))) {
            String key = (String)Constants.INDEXES.get(index);
            reference = Rib.deserialize(raw.getValue(key), clazz);
        }
        return reference;
    }

    static <T> void set(JsonObject data, String field, T value, Integer argIndex) {
        JsonObject reference = RibData.getData(data, argIndex);
        if (Objects.nonNull(reference)) {
            reference.put(field, value);
        }
    }

    private static JsonObject getData(JsonObject data, Integer argIndex) {
        JsonObject found = new JsonObject();
        Object reference = data.getValue("data");
        if (reference instanceof JsonObject) {
            found = (JsonObject)reference;
        }
        if (null == argIndex) {
            JsonObject body = found.fieldNames().stream().filter(Objects::nonNull).map(arg_0 -> ((JsonObject)found).getValue(arg_0)).filter(value -> value instanceof JsonObject).map(item -> (JsonObject)item).findFirst().orElse(null);
            if (!Ut.isNil((JsonObject)body)) {
                found = body;
            }
        } else {
            found = found.getJsonObject((String)Constants.INDEXES.get(argIndex));
        }
        return found;
    }
}

