/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune.envelop;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class RibIr {
    private static final Annal LOGGER = Annal.get(RibIr.class);

    RibIr() {
    }

    static void irProjection(JsonObject reference, JsonArray projection, boolean clear) {
        if (clear) {
            reference.put("projection", projection.copy());
        } else {
            Set<String> originalSet = RibIr.originalProjection(reference);
            projection.copy().stream().filter(Objects::nonNull).map(item -> (String)item).forEach(originalSet::add);
            reference.put("projection", Ut.toJArray(originalSet));
        }
        LOGGER.info("Final query ( projection ): \n{0}", new Object[]{reference.encodePrettily()});
    }

    static void irCriteria(JsonObject reference, JsonObject criteria, boolean clear) {
        if (clear) {
            reference.put("criteria", criteria.copy());
        } else {
            JsonObject originalCriteria = reference.getJsonObject("criteria");
            JsonObject criteriaResult = new JsonObject();
            if (Ut.isNil((JsonObject)originalCriteria)) {
                criteriaResult.mergeIn(criteria.copy());
            } else {
                criteriaResult.put("", Boolean.TRUE);
                criteriaResult.put("$ORIGINAL$", originalCriteria.copy());
                criteriaResult.put("$MATRIX$", criteria.copy());
            }
            reference.put("criteria", criteriaResult);
        }
        LOGGER.info("Final query ( criteria ): \n{0}", new Object[]{reference.encodePrettily()});
    }

    private static Set<String> originalProjection(JsonObject reference) {
        HashSet<String> projectionSet = new HashSet<String>();
        if (reference.containsKey("projection")) {
            reference.getJsonArray("projection").stream().map(item -> (String)item).forEach(projectionSet::add);
        }
        return projectionSet;
    }
}

