/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.extension.region;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.extension.PlugRegion;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;

public abstract class AbstractRegion
implements PlugRegion {
    private final transient JsonObject config = new JsonObject();

    @Override
    public PlugRegion bind(JsonObject config) {
        this.config.mergeIn(config);
        return this;
    }

    protected JsonObject config() {
        return this.config;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected boolean isEnabled(RoutingContext context) {
        String prefix = this.config.getString("prefix");
        if (Ut.isNil((String)prefix)) {
            this.getLogger().info("Data Region require config `prefix` attribute value, but now is null. Disabled! ", new Object[0]);
            return false;
        }
        String requestUri = context.request().path();
        return requestUri.startsWith(prefix);
    }
}

