/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.serialization.BigDecimalSaber;
import io.vertx.up.uca.serialization.BooleanSaber;
import io.vertx.up.uca.serialization.BufferSaber;
import io.vertx.up.uca.serialization.ByteArraySaber;
import io.vertx.up.uca.serialization.CollectionSaber;
import io.vertx.up.uca.serialization.CommonSaber;
import io.vertx.up.uca.serialization.DateSaber;
import io.vertx.up.uca.serialization.DoubleSaber;
import io.vertx.up.uca.serialization.EnumSaber;
import io.vertx.up.uca.serialization.FileSaber;
import io.vertx.up.uca.serialization.FloatSaber;
import io.vertx.up.uca.serialization.IntegerSaber;
import io.vertx.up.uca.serialization.Java8DataTimeSaber;
import io.vertx.up.uca.serialization.JsonArraySaber;
import io.vertx.up.uca.serialization.JsonObjectSaber;
import io.vertx.up.uca.serialization.LongSaber;
import io.vertx.up.uca.serialization.Saber;
import io.vertx.up.uca.serialization.ShortSaber;
import io.vertx.up.uca.serialization.StringBufferSaber;
import io.vertx.up.uca.serialization.StringSaber;
import io.vertx.up.util.Ut;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ZeroSerializer {
    private static final ConcurrentMap<Class<?>, Saber> SABERS = new ConcurrentHashMap<Class<?>, Saber>(){
        {
            this.put(Integer.TYPE, Ut.singleton(IntegerSaber.class, (Object[])new Object[0]));
            this.put(Integer.class, Ut.singleton(IntegerSaber.class, (Object[])new Object[0]));
            this.put(Short.TYPE, Ut.singleton(ShortSaber.class, (Object[])new Object[0]));
            this.put(Short.class, Ut.singleton(ShortSaber.class, (Object[])new Object[0]));
            this.put(Long.TYPE, Ut.singleton(LongSaber.class, (Object[])new Object[0]));
            this.put(Long.class, Ut.singleton(LongSaber.class, (Object[])new Object[0]));
            this.put(Double.TYPE, Ut.singleton(DoubleSaber.class, (Object[])new Object[0]));
            this.put(Double.class, Ut.singleton(DoubleSaber.class, (Object[])new Object[0]));
            this.put(LocalDate.class, Ut.singleton(Java8DataTimeSaber.class, (Object[])new Object[0]));
            this.put(LocalDateTime.class, Ut.singleton(Java8DataTimeSaber.class, (Object[])new Object[0]));
            this.put(LocalTime.class, Ut.singleton(Java8DataTimeSaber.class, (Object[])new Object[0]));
            this.put(Float.TYPE, Ut.singleton(FloatSaber.class, (Object[])new Object[0]));
            this.put(Float.class, Ut.singleton(FloatSaber.class, (Object[])new Object[0]));
            this.put(BigDecimal.class, Ut.singleton(BigDecimalSaber.class, (Object[])new Object[0]));
            this.put(Enum.class, Ut.singleton(EnumSaber.class, (Object[])new Object[0]));
            this.put(Boolean.TYPE, Ut.singleton(BooleanSaber.class, (Object[])new Object[0]));
            this.put(Boolean.class, Ut.singleton(BooleanSaber.class, (Object[])new Object[0]));
            this.put(Date.class, Ut.singleton(DateSaber.class, (Object[])new Object[0]));
            this.put(Calendar.class, Ut.singleton(DateSaber.class, (Object[])new Object[0]));
            this.put(JsonObject.class, Ut.singleton(JsonObjectSaber.class, (Object[])new Object[0]));
            this.put(JsonArray.class, Ut.singleton(JsonArraySaber.class, (Object[])new Object[0]));
            this.put(String.class, Ut.singleton(StringSaber.class, (Object[])new Object[0]));
            this.put(StringBuffer.class, Ut.singleton(StringBufferSaber.class, (Object[])new Object[0]));
            this.put(StringBuilder.class, Ut.singleton(StringBufferSaber.class, (Object[])new Object[0]));
            this.put(Buffer.class, Ut.singleton(BufferSaber.class, (Object[])new Object[0]));
            this.put(Set.class, Ut.singleton(CollectionSaber.class, (Object[])new Object[0]));
            this.put(List.class, Ut.singleton(CollectionSaber.class, (Object[])new Object[0]));
            this.put(Collection.class, Ut.singleton(CollectionSaber.class, (Object[])new Object[0]));
            this.put(byte[].class, Ut.singleton(ByteArraySaber.class, (Object[])new Object[0]));
            this.put(Byte[].class, Ut.singleton(ByteArraySaber.class, (Object[])new Object[0]));
            this.put(File.class, Ut.singleton(FileSaber.class, (Object[])new Object[0]));
        }
    };

    public static Object getValue(Class<?> paramType, String literal) {
        Object reference = null;
        if (null != literal) {
            Saber saber = paramType.isEnum() ? (Saber)SABERS.get(Enum.class) : (Collection.class.isAssignableFrom(paramType) ? (Saber)SABERS.get(Collection.class) : (Saber)SABERS.get(paramType));
            if (null == saber) {
                saber = (Saber)Ut.singleton(CommonSaber.class, (Object[])new Object[0]);
            }
            reference = saber.from(paramType, literal);
        }
        return reference;
    }

    public static <T> boolean isDirect(T input) {
        boolean result = false;
        if (null != input) {
            Class<?> cls = input.getClass();
            result = JsonObject.class == cls ? false : (JsonArray.class == cls ? false : SABERS.containsKey(cls));
        }
        return result;
    }

    public static <T> Object toSupport(T input) {
        try {
            Object reference = null;
            if (null != input) {
                Class<?> type;
                Class<?> cls = input.getClass();
                Saber saber = cls.isEnum() ? (Saber)SABERS.get(Enum.class) : (Calendar.class.isAssignableFrom(cls) ? (Saber)SABERS.get(Date.class) : (Collection.class.isAssignableFrom(cls) ? (Saber)SABERS.get(Collection.class) : (cls.isArray() ? (Byte.TYPE == (type = cls.getComponentType()) || Byte.class == type ? (Saber)SABERS.get(byte[].class) : (Saber)SABERS.get(Collection.class)) : (Saber)SABERS.get(cls))));
                if (null == saber) {
                    saber = (Saber)Ut.singleton(CommonSaber.class, (Object[])new Object[0]);
                }
                reference = saber.from(input);
            }
            return reference;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

