/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.secure.handler.AuthPhylum;

abstract class AuthorizationAuthPhylum
extends AuthPhylum {
    protected final Type type;

    AuthorizationAuthPhylum(AuthProvider authProvider, Type type) {
        super(authProvider);
        this.type = type;
    }

    AuthorizationAuthPhylum(AuthProvider authProvider, String realm, Type type) {
        super(authProvider, realm);
        this.type = type;
    }

    protected final void parseAuthorization(RoutingContext ctx, boolean optional, Handler<AsyncResult<String>> handler) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            handler.handle((Object)Future.failedFuture((Throwable)this.UNAUTHORIZED));
            return;
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                handler.handle((Object)Future.failedFuture((Throwable)this.BAD_REQUEST));
                return;
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                handler.handle((Object)Future.failedFuture((Throwable)this.UNAUTHORIZED));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)authorization.substring(idx + 1).trim()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }
    }
}

