/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.secure.handler.AuthorizationAuthPhylum;
import io.vertx.up.secure.handler.JwtOstium;
import io.vertx.up.secure.provider.JwtAuth;
import java.util.List;

public class JwtPhylum
extends AuthorizationAuthPhylum
implements JwtOstium {
    private final String skip;
    private final JsonObject options;

    public JwtPhylum(JwtAuth authProvider, String skip) {
        super((AuthProvider)authProvider, AuthorizationAuthPhylum.Type.BEARER);
        this.skip = skip;
        this.options = new JsonObject();
    }

    @Override
    public JwtOstium setAudience(List<String> audience) {
        this.options.put("audience", new JsonArray(audience));
        return this;
    }

    @Override
    public JwtOstium setIssuer(String issuer) {
        this.options.put("issuer", issuer);
        return this;
    }

    @Override
    public JwtOstium setIgnoreExpiration(boolean ignoreExpiration) {
        this.options.put("ignoreExpiration", Boolean.valueOf(ignoreExpiration));
        return this;
    }

    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        if (this.skip != null && context.normalisedPath().startsWith(this.skip)) {
            context.next();
        } else {
            this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
                if (parseAuthorization.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)new JsonObject().put("jwt", (String)parseAuthorization.result()).put("options", this.options)));
                }
            }));
        }
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        return "Bearer";
    }
}

