/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.inquire;

import io.vertx.tp.error.WallMethodMultiException;
import io.vertx.up.annotations.Authenticate;
import io.vertx.up.annotations.Authorize;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class PhylumAuth {
    private final transient Class<?> clazz;
    private final transient Annal logger;
    private final transient Method[] methods;

    private PhylumAuth(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = Annal.get(clazz);
        this.methods = clazz.getDeclaredMethods();
    }

    public static PhylumAuth create(Class<?> clazz) {
        return new PhylumAuth(clazz);
    }

    public PhylumAuth verify() {
        Fn.outUp((boolean)this.verifyMethod(this.methods, Authenticate.class), (Annal)this.logger, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authenticate.class.getSimpleName(), this.clazz.getName()});
        Fn.outUp((boolean)this.verifyMethod(this.methods, Authorize.class), (Annal)this.logger, WallMethodMultiException.class, (Object[])new Object[]{this.getClass(), Authorize.class.getSimpleName(), this.clazz.getName()});
        return this;
    }

    public void mount(Cliff reference) {
        reference.setProxy(Ut.singleton(this.clazz, (Object[])new Object[0]));
        Optional<Method> authenticateMethod = Arrays.stream(this.methods).filter(item -> item.isAnnotationPresent(Authenticate.class)).findFirst();
        reference.getAuthorizer().setAuthenticate((Method)authenticateMethod.orElse(null));
        Optional<Method> authorizeMethod = Arrays.stream(this.methods).filter(item -> item.isAnnotationPresent(Authorize.class)).findFirst();
        reference.getAuthorizer().setAuthorize((Method)authorizeMethod.orElse(null));
    }

    private boolean verifyMethod(Method[] methods, Class<? extends Annotation> clazz) {
        long found = Arrays.stream(methods).filter(method -> method.isAnnotationPresent(clazz)).count();
        return 1L < found;
    }
}

