/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.provider;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.jwt.JWT;
import io.vertx.up.exception.web._401JwtAudientException;
import io.vertx.up.exception.web._401JwtExpiredException;
import io.vertx.up.exception.web._401JwtIssuerException;
import io.vertx.up.exception.web._500JwtRuntimeException;
import io.vertx.up.exception.web._500SecurityNotImplementException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Security;
import io.vertx.up.secure.provider.JwtAuth;
import io.vertx.up.secure.provider.JwtSecurer;
import io.vertx.up.unity.Ux;
import java.util.Collections;
import java.util.function.Supplier;

public class JwtAuthProvider
implements JwtAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final String AUTH_POOL = "JWT_AUTH_TOKEN_POOL";
    private static final Annal LOGGER = Annal.get(JwtAuthProvider.class);
    private final JWT jwt;
    private final String permissionsClaimKey;
    private final JWTOptions jwtOptions;
    private final transient JwtSecurer securer = JwtSecurer.create();
    private transient AsyncMap<String, Boolean> sessionTokens;

    JwtAuthProvider(Vertx vertx, JWTAuthOptions config) {
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.securer.setPermissionsClaimKey(this.permissionsClaimKey);
        this.jwtOptions = config.getJWTOptions();
        this.jwt = Ux.Jwt.create(config, arg_0 -> ((FileSystem)vertx.fileSystem()).readFileBlocking(arg_0));
        vertx.sharedData().getAsyncMap(AUTH_POOL, res -> {
            if (res.succeeded()) {
                LOGGER.debug("( Auth ) The async shared map has been initialized: name = {0}", new Object[]{AUTH_POOL});
                this.sessionTokens = (AsyncMap)res.result();
            }
        });
    }

    @Override
    public JwtAuth bind(Supplier<Security> supplier) {
        Security security = supplier.get();
        Fn.outWeb((null == security ? 1 : 0) != 0, _500SecurityNotImplementException.class, (Object[])new Object[]{this.getClass()});
        this.securer.setSecurity(security);
        return this;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> handler) {
        LOGGER.info("( Auth ) Auth Information: {0}", new Object[]{authInfo.encode()});
        String token = authInfo.getString("jwt");
        if (null == this.sessionTokens) {
            LOGGER.debug("( Auth ) No authorization cached: token = {0}", new Object[]{token});
            this.prerequisite(token).compose(nil -> this.securer.authenticate(authInfo)).onComplete(this.authorized(token, handler));
        } else {
            this.sessionTokens.get((Object)token, res -> {
                if (null != res && null != res.result() && ((Boolean)res.result()).booleanValue()) {
                    LOGGER.info("( Auth ) The async shared map cache has been hitted by key = {0}, value = {1}", new Object[]{token, res.result()});
                    this.securer.authorize(authInfo).onComplete(this.authorized(token, handler));
                } else {
                    LOGGER.debug("( Auth ) The async shared map cache has not been hitted by key = {0}", new Object[]{token});
                    this.prerequisite(token).compose(nil -> this.securer.authenticate(authInfo)).onComplete(this.authorized(token, handler));
                }
            });
        }
    }

    private Handler<AsyncResult<User>> authorized(String token, Handler<AsyncResult<User>> handler) {
        return user -> {
            if (user.succeeded()) {
                this.sessionTokens.put((Object)token, (Object)Boolean.TRUE, result -> {
                    LOGGER.debug("( Auth ) The async shared map cache has been put with key = {0}, value = {1}", new Object[]{token, Boolean.TRUE});
                    handler.handle((Object)Future.succeededFuture((Object)user.result()));
                });
            } else {
                Throwable error = user.cause();
                Ux.debug(error, () -> error);
                handler.handle((Object)Future.failedFuture((Throwable)error));
            }
        };
    }

    private Future<String> prerequisite(String token) {
        try {
            JsonObject payload = this.jwt.decode(token);
            if (this.jwt.isExpired(payload, this.jwtOptions)) {
                return Future.failedFuture((Throwable)((Object)new _401JwtExpiredException(this.getClass(), payload)));
            }
            if (this.jwtOptions.getAudience() != null) {
                JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                    return Future.failedFuture((Throwable)((Object)new _401JwtAudientException(this.getClass(), Json.encode((Object)this.jwtOptions.getAudience()))));
                }
            }
            if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
                return Future.failedFuture((Throwable)((Object)new _401JwtIssuerException(this.getClass(), payload.getString("iss"))));
            }
            return Future.succeededFuture((Object)token);
        }
        catch (RuntimeException ex) {
            return Future.failedFuture((Throwable)((Object)new _500JwtRuntimeException(this.getClass(), ex)));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject _claims = claims.copy();
        if (options.getPermissions() != null && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, new JsonArray(options.getPermissions()));
        }
        return this.jwt.sign(_claims, options);
    }
}

