/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cosmic;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.eon.em.HttpsType;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cosmic.Emitter;
import io.vertx.up.uca.cosmic.TrustX509;
import io.vertx.up.util.Ut;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public abstract class AbstractEmitter
implements Emitter {
    private final transient Integration integration;

    public AbstractEmitter(Integration integration) {
        this.integration = integration;
    }

    protected SSLContext sslContext() {
        TrustManager[] trustCerts = new TrustManager[]{new TrustX509()};
        String sslMode = (String)this.integration.getOption("https", (Object)HttpsType.TLS.name());
        HttpsType type = (HttpsType)Ut.toEnum(() -> sslMode, HttpsType.class, (Enum)HttpsType.TLS);
        try {
            SSLContext context = SSLContext.getInstance(type.name());
            context.init(null, trustCerts, new SecureRandom());
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            this.logger().jvm((Throwable)ex);
            return null;
        }
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected Integration integration() {
        return this.integration;
    }

    protected abstract void initialize();

    @Override
    public JsonObject requestJ(String apiKey, JsonObject params, MultiMap headers) {
        String content = this.request(apiKey, params, headers);
        return Ut.isJObject((String)content) ? Ut.toJObject((String)content) : new JsonObject();
    }

    @Override
    public JsonArray requestA(String apiKey, JsonObject params, MultiMap headers) {
        String content = this.request(apiKey, params, headers);
        return Ut.isJArray((String)content) ? Ut.toJArray((String)content) : new JsonArray();
    }
}

