/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.deployment;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Agent;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.agent.Arrange;
import io.vertx.up.eon.em.DeployMode;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.deployment.Rotate;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DeployRotate
implements Rotate {
    private static final String KEY_DEPLOYMENT = "deployment";
    private static final Annal LOGGER;
    private static final ConcurrentMap<Class<?>, JsonObject> OPTIONS;
    private static final Node<JsonObject> VISITOR;

    private static void initOptions(JsonObject options) {
        if (!Ut.isNil((JsonObject)options)) {
            options.fieldNames().forEach(className -> {
                Class clazz = Ut.clazz((String)className);
                JsonObject option = options.getJsonObject(className);
                OPTIONS.put(clazz, option);
            });
        }
    }

    @Override
    public DeploymentOptions spinAgent(Class<?> clazz) {
        Agent annotation = clazz.getDeclaredAnnotation(Agent.class);
        DeploymentOptions options = this.spinOpts((Annotation)annotation);
        this.spinConfig(clazz, options);
        options.setWorker(false);
        LOGGER.info("( Verticle ) The deployment options has been captured: instances = {0}, group = {1}, ha = {2}, content = {3}", new Object[]{options.getInstances(), options.getIsolationGroup(), options.isHa(), options.toJson()});
        return options;
    }

    @Override
    public DeploymentOptions spinWorker(Class<?> clazz) {
        Worker annotation = clazz.getDeclaredAnnotation(Worker.class);
        DeploymentOptions options = this.spinOpts((Annotation)annotation);
        this.spinConfig(clazz, options);
        options.setWorker(true);
        LOGGER.info("( Verticle ) The deployment options has been captured: instances = {0}, group = {1}, ha = {2}, content = {3}", new Object[]{options.getInstances(), options.getIsolationGroup(), options.isHa(), options.toJson()});
        return options;
    }

    private void spinConfig(Class<?> clazz, DeploymentOptions options) {
        if (!OPTIONS.isEmpty()) {
            JsonObject configOpts = OPTIONS.getOrDefault(clazz, new JsonObject());
            JsonObject codeOpts = options.toJson();
            codeOpts.mergeIn(configOpts, true);
            options.fromJson(codeOpts);
        }
    }

    private DeploymentOptions spinOpts(Annotation annotation) {
        int instances = (Integer)Ut.invoke((Object)annotation, (String)"instances", (Object[])new Object[0]);
        boolean ha = (Boolean)Ut.invoke((Object)annotation, (String)"ha", (Object[])new Object[0]);
        String group = (String)Ut.invoke((Object)annotation, (String)"group", (Object[])new Object[0]);
        DeploymentOptions options = new DeploymentOptions();
        options.setHa(ha);
        options.setInstances(instances);
        options.setIsolationGroup(group);
        return options;
    }

    static {
        JsonObject deployOptions;
        Arrange arrange;
        DeployMode mode;
        LOGGER = Annal.get(DeployRotate.class);
        OPTIONS = new ConcurrentHashMap();
        VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
        JsonObject options = (JsonObject)VISITOR.read();
        if (options.containsKey(KEY_DEPLOYMENT) && DeployMode.CONFIG == (mode = (arrange = (Arrange)Ut.deserialize((JsonObject)(deployOptions = options.getJsonObject(KEY_DEPLOYMENT)), Arrange.class)).getMode())) {
            LOGGER.info("Zero container will select new DeployMode ( mode = {0} ).", new Object[]{mode});
            DeployRotate.initOptions(arrange.getOptions());
        }
    }
}

