/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.invoker;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.invoker.Invoker;
import io.vertx.up.uca.invoker.InvokerUtil;
import io.vertx.up.uca.registry.Uddi;
import io.vertx.up.uca.registry.UddiClient;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.function.Function;

public abstract class AbstractInvoker
implements Invoker {
    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected Future invokeJson(Object proxy, Method method, Envelop envelop) {
        Object reference = envelop.data();
        Class<?> argType = method.getParameterTypes()[0];
        Object arguments = Ut.deserialize((String)Ut.toString(reference), argType);
        return (Future)Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
    }

    protected Object invokeInternal(Object proxy, Method method, Envelop envelop) {
        Class<?> firstArg;
        Class<?>[] argTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        Object returnValue = 1 == method.getParameterCount() ? (Envelop.class == (firstArg = argTypes[0]) ? Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop}) : InvokerUtil.invokeSingle(proxy, method, envelop)) : InvokerUtil.invokeMulti(proxy, method, envelop);
        return returnValue;
    }

    protected <I> Function<I, Future<Envelop>> nextEnvelop(Vertx vertx, Method method) {
        return item -> this.nextEnvelop(vertx, method, item);
    }

    protected <T> Future<Envelop> nextEnvelop(Vertx vertx, Method method, T result) {
        UddiClient client = Uddi.client(this.getClass());
        return client.bind(vertx).bind(method).connect(Ux.fromEnvelop(result));
    }
}

