/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.invoker;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroSerializer;
import io.vertx.up.uca.serialization.TypedArgument;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.AsyncSignatureException;
import io.vertx.zero.exception.WorkerArgumentException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;

public class InvokerUtil {
    private static final Annal LOGGER = Annal.get(InvokerUtil.class);

    static boolean isVoid(Method method) {
        Class<?> returnType = method.getReturnType();
        return Void.TYPE == returnType || Void.class == returnType;
    }

    public static void verifyArgs(Method method, Class<?> target) {
        Class<?>[] params = method.getParameterTypes();
        Annal logger = Annal.get(target);
        Fn.outUp((0 == params.length ? 1 : 0) != 0, (Annal)logger, WorkerArgumentException.class, (Object[])new Object[]{target, method});
    }

    static void verify(boolean condition, Class<?> returnType, Class<?> paramType, Class<?> target) {
        Annal logger = Annal.get(target);
        Fn.outUp((boolean)condition, (Annal)logger, AsyncSignatureException.class, (Object[])new Object[]{target, returnType.getName(), paramType.getName()});
    }

    private static Object getValue(Class<?> type, Envelop envelop, Supplier<Object> defaultSupplier) {
        Object value;
        if (Session.class == type) {
            value = envelop.session();
        } else {
            value = defaultSupplier.get();
            Object object = null == value ? null : ZeroSerializer.getValue(type, value.toString());
        }
        return value;
    }

    static Object invokeMulti(Object proxy, Method method, Envelop envelop) {
        Object reference = envelop.data();
        Object[] arguments = new Object[method.getParameterCount()];
        JsonObject json = (JsonObject)reference;
        Class<?>[] types = method.getParameterTypes();
        int adjust = 0;
        for (int idx = 0; idx < types.length; ++idx) {
            Class<?> type = types[idx];
            Object analyzed = TypedArgument.analyze(envelop, type);
            if (Objects.isNull(analyzed)) {
                int current = idx - adjust;
                Object value = json.getValue(String.valueOf(current));
                if (Objects.isNull(value)) {
                    arguments[idx] = null;
                    continue;
                }
                arguments[idx] = ZeroSerializer.getValue(type, value.toString());
                continue;
            }
            arguments[idx] = analyzed;
            ++adjust;
        }
        return Ut.invoke((Object)proxy, (String)method.getName(), (Object[])arguments);
    }

    static Object invokeSingle(Object proxy, Method method, Envelop envelop) {
        Class<?> argType = method.getParameterTypes()[0];
        Object analyzed = TypedArgument.analyze(envelop, argType);
        if (Objects.isNull(analyzed)) {
            JsonObject json;
            Object reference;
            Object parameters = reference = Objects.nonNull(envelop) ? envelop.data() : new JsonObject();
            if (JsonObject.class == reference.getClass() && InvokerUtil.isInterface(json = (JsonObject)reference) && 1 == json.fieldNames().size()) {
                parameters = json.getValue("0");
            }
            Object arguments = ZeroSerializer.getValue(argType, Ut.toString((Object)parameters));
            return Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
        }
        return Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{analyzed});
    }

    private static boolean isInterface(JsonObject json) {
        long count = json.fieldNames().stream().filter(Ut::isInteger).count();
        LOGGER.debug("( isInterface Mode ) Parameter count: {0}, json: {1}", new Object[]{count, json.encode()});
        return count == (long)json.fieldNames().size();
    }
}

