/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.center;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.log.Debugger;
import io.vertx.up.uca.job.center.AbstractAgha;
import io.vertx.up.util.Ut;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

class FixedAgha
extends AbstractAgha {
    FixedAgha() {
    }

    @Override
    public Future<Long> begin(Mission mission) {
        long delay = this.getDelay(mission);
        this.moveOn(mission, true);
        Promise future = Promise.promise();
        long jobId = this.interval().startAt(delay, mission.getDuration(), (Handler<Long>)((Handler)timeId -> this.working(mission, () -> {
            future.tryComplete(timeId);
            Ut.itRepeat((Integer)2, () -> this.moveOn(mission, true));
        })));
        JobPool.mount(jobId, mission.getCode());
        if (Debugger.onJooqCondition()) {
            this.getLogger().info("[ Job ] `{0}` The scheduler will start after {1} ms, then scheduled duration {2} (-1 means ONCE) ms in each, timerId = {3}", new Object[]{mission.getCode(), String.valueOf(delay), String.valueOf(mission.getDuration()), String.valueOf(jobId)});
        }
        return future.future();
    }

    private long getDelay(Mission mission) {
        Instant end = mission.getInstant();
        Instant start = Instant.now();
        long delay = ChronoUnit.MILLIS.between(start, end);
        if (0L < delay) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
            this.getLogger().info("[ Job ] Job \"{0}\" will started after `{1}` ", new Object[]{mission.getCode(), format.format(delay)});
        }
        return delay < 0L ? 0L : delay;
    }
}

