/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.phase;

import io.vertx.up.atom.worker.Mission;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.fn.Actuator;
import io.vertx.up.fn.Fn;
import io.vertx.up.runtime.Runner;
import io.vertx.up.uca.job.phase.Pool;
import io.vertx.up.uca.job.plugin.JobIncome;
import io.vertx.up.uca.job.plugin.JobOutcome;
import io.vertx.up.util.Ut;
import java.util.Objects;

class Element {
    Element() {
    }

    static JobIncome income(Mission mission) {
        Class<?> incomeCls = mission.getIncome();
        JobIncome income = null;
        if (Objects.nonNull(incomeCls) && Ut.isImplement(incomeCls, JobIncome.class)) {
            income = (JobIncome)Fn.pool(Pool.INCOMES, (Object)mission.getCode(), () -> (JobIncome)Ut.instance((Class)incomeCls, (Object[])new Object[0]));
        }
        return income;
    }

    static JobOutcome outcome(Mission mission) {
        Class<?> outcomeCls = mission.getOutcome();
        JobOutcome outcome = null;
        if (Objects.nonNull(outcomeCls) && Ut.isImplement(outcomeCls, JobOutcome.class)) {
            outcome = (JobOutcome)Fn.pool(Pool.OUTCOMES, (Object)mission.getCode(), () -> (JobOutcome)Ut.instance((Class)outcomeCls, (Object[])new Object[0]));
        }
        return outcome;
    }

    static void onceLog(Mission mission, Actuator actuator) {
        if (JobType.ONCE == mission.getType()) {
            Runner.run(() -> ((Actuator)actuator).execute(), (String)"once-logger-debug");
        }
    }
}

