/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.phase;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.phase.Element;
import io.vertx.up.uca.job.plugin.JobIncome;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

class Input {
    private static final Annal LOGGER = Annal.get(Input.class);
    private final transient Vertx vertx;
    private final transient Refer underway = new Refer();

    Input(Vertx vertx) {
        this.vertx = vertx;
    }

    Refer underway() {
        return this.underway;
    }

    Future<Envelop> inputAsync(Mission mission) {
        String address = mission.getIncomeAddress();
        if (Ut.isNil((String)address)) {
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 1. Input new data of JsonObject", new Object[]{mission.getCode()}));
            return Future.succeededFuture((Object)Envelop.okJson());
        }
        LOGGER.info("[ Job ] {0} event bus enabled: {1}", new Object[]{"Income", address});
        Promise input = Promise.promise();
        EventBus eventBus = this.vertx.eventBus();
        eventBus.consumer(address, handler -> {
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 1. Input from address {1}", new Object[]{mission.getCode(), address}));
            Envelop envelop = (Envelop)handler.body();
            if (Objects.isNull(envelop)) {
                input.complete((Object)Envelop.ok());
            } else {
                input.complete((Object)envelop);
            }
        });
        return input.future();
    }

    Future<Envelop> incomeAsync(Envelop envelop, Mission mission) {
        if (envelop.valid()) {
            JobIncome income = Element.income(mission);
            if (Objects.isNull(income)) {
                Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 2. Input without `JobIncome`", new Object[]{mission.getCode()}));
                return Future.succeededFuture((Object)envelop);
            }
            LOGGER.info("[ Job ] {0} selected: {1}", new Object[]{"JobIncome", income.getClass().getName()});
            Ut.contract((Object)income, Vertx.class, (Object)this.vertx);
            Ut.contract((Object)income, Mission.class, (Object)mission);
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 2. Input with `JobIncome` = {1}", new Object[]{mission.getCode(), income.getClass().getName()}));
            return income.underway().compose(refer -> {
                this.underway.add(refer.get());
                return income.beforeAsync(envelop);
            });
        }
        Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] Terminal with error: {1}", new Object[]{mission.getCode(), ((Object)((Object)envelop.error())).getClass().getName()}));
        return Ux.future(envelop);
    }
}

